/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
 
#ifndef DBUS_SERVICE_H
#define DBUS_SERVICE_H

#include <glib.h>

#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus.h>
#include <dbus/dbus-glib-bindings.h>
#include <dbus/dbus-glib-lowlevel.h>

#include <ui/interface.h>

void declareDbusServices();
void undeclareDbusServices();

/*
cf. dbus-error.h
#define CONTACTINFOS_DBUS_ERROR  g_quark_from_static_string ("contactinfos")
*/

typedef struct _ContactinfosService ContactinfosService;
typedef struct _ContactinfosServiceClass ContactinfosServiceClass;

#define CONTACTINFOS_TYPE_SERVICE               (contactinfos_service_get_type ())
#define CONTACTINFOS_SERVICE(object)            (G_TYPE_CHECK_INSTANCE_CAST((object), CONTACTINFOS_TYPE_SERVICE, ContactinfosService))
#define CONTACTINFOS_SERVICE_CLASS(klass)       (G_TYPE_CHACK_CLASS_CAST((klass), CONTACTINFOS_TYPE_SERVICE, ContactinfosServiceClass))
#define CONTACTINFOS_IS_SERVICE(object)         (G_TYPE_CHECK_INSTANCE_TYPE((object), CONTACTINFOS_TYPE_SERVICE))
#define CONTACTINFOS_IS_SERVICE_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE((klass), SCONTACTINFOS_TYPE_SERVICE))
#define CONTACTINFOS_SERVICE_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS((object), CONTACTINFOS_TYPE_SERVICE, ContactinfosServiceClass))

struct _ContactinfosService {
	GObject base;
	DBusGConnection *connection;
	GError *error;
    
    /* <public> */
	AppUIData *appData;
	gpointer backendData;
	guint requestedInfos;
	gchar * searchText;
	gboolean showGui;
	gboolean confirm;
	gboolean multipleReponse;
	guint upperLimit;
};

#define SIGNAL_SEARCH_CONTACT_INFOS "searchContactInfos"
struct _ContactinfosServiceClass {
	GObjectClass base;
	guint search_signal_id;
};

GType contactinfos_service_get_type (void);

gboolean server_is_available (ContactinfosService *svc, gboolean* availability, GError **error);
gboolean server_get_available_contact_infos (ContactinfosService *server, guint requestedInfos, guint* availableInfos, GError **error);
gboolean server_get_contact_infos (ContactinfosService *svc, guint requestedInfos, gchar * searchText, gboolean showGui, gboolean confirm, gboolean multipleReponse, guint upperLimit, gboolean* availability, GError **error);

#endif
