/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <appdata.h>

#include <gtk/gtkmain.h>

#include <dbus/dbus-service.h>

#include <config.h>

#if HILDON == 1
#include <hildon/hildon.h>
#else
#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/hildon-banner.h>
#endif

#include <libintl.h>
#include <locale.h>
#include <libosso.h>

#define _(String) gettext(String)

static AppData *create_data ()
{
    AppData *result = g_new0( AppData, 1 );

    result->osso = osso_initialize ( PACKAGE, VERSION, TRUE, NULL );
    g_assert ( result->osso );
    return result;
}

/* Here we clean up all the data that we allocated */
static void destroy_data ( AppData *data )
{
    g_free ( data );
}

int main( int argc, char* argv[] )
{
	AppData* data; 
/*
	HildonProgram* program; 
*/
	g_type_init();
	
	/* Initialise the locale stuff */
	setlocale ( LC_ALL, "" );
	bindtextdomain ( GETTEXT_PACKAGE, LOCALEDIR );
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain ( GETTEXT_PACKAGE );

	/* Init the gtk - must be called before any hildon stuff */
	gtk_init( &argc, &argv );

/*
	program = HILDON_PROGRAM ( hildon_program_get_instance () );
*/
	g_set_application_name ( _("ContactInfos") );

	if(!g_thread_supported()) {
	g_thread_init(NULL);
	}

	/* Create the data and views for our application */
	data = create_data ();

	declareDbusServices();

	/* Begin the main app */
	gtk_main();

	undeclareDbusServices();
	/* Clean up */
	destroy_data ( data );

	return 0;
}     

