/*
 * Copyright (C) 2008, 2009 Andrew Sichevoi.
 *
 * This file is part of Conler (http://thekondor.net/conler).
 *
 * Conler is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conler. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CONLER_APPDATA_H
#define _CONLER_APPDATA_H

#include <glib/gslist.h>
#include <gtk/gtk.h>

#ifdef MAEMO
  #include <hildon/hildon.h>
  #include <libosso.h>
#endif


#define GET_APP_DATA(ptr)  AppData_s* app_data = (AppData_s* )(ptr);

// TODO: general idea when AppData_s must be passed explicitly
//       to each slot currently doesn't seem good -- refactoring
//       is required: AppData_s instance must be global.
typedef struct
{
#ifdef MAEMO
    osso_context_t* osso_context;

    HildonProgram* program;
    HildonWindow* mainWindow;
// TODO: make viewFlags with bit mask instead
    gboolean fullscreen;
#else
    GtkWidget* mainWindow;
#endif

    GtkWidget* apListView;
    GtkWidget* commandListView;

    /* Buttons */
    GtkToolItem* helpToolButton;
    GtkToolItem* quitToolButton;
    GtkToolItem* applyToolButton;

    /* Data */
    GSList* access_points;

    /* State */
    gboolean changed;

    /* Satellitic Widgets */
    struct
    {
        GtkCellRenderer* enabledCellRndr;
        GtkCellRenderer* nameCellRndr;
        GtkTreeIter* currentIter;

        GtkToolItem* disableToolButton;
        GtkToolItem* addToolButton;
        GtkToolItem* delToolButton;
        GtkToolItem* renameToolButton;
    } ap;

    struct
    {
        GtkCellRenderer* cmdlineCellRndr;
        GtkCellRenderer* disabledCellRndr;
        GtkCellRenderer* superuserCellRndr;

        GtkToolItem* moveUpToolButton;
        GtkToolItem* moveDownToolButton;
        GtkToolItem* addToolButton;
        GtkToolItem* delToolButton;
        GtkToolItem* editToolButton;
    } cmd;

} AppData_s;


#endif

