#!/bin/sh

# NOTES: original script was taken from http://nick.borko.org/update-dyndns
#        Current version contains some minor modifications to be able to run
#        on Maemo OS (from Conler, http://thekondor.net/conler)
#
# dyndns update script
# Copyright (c) 2001 by Nicholas Borko
#
# This script will update dyndns records for a ppp connection. It only does
# simple updates and does not handle MX records, offline mode, or any kind
# of syntax checking on what you supply it. However, it *will* query the
# dyndns name servers to see if you actually need to do an update, which
# means you can run it in a cron job with no problems. Just remember: I'm
# not responsible for your stupidity or dyndns abuse.
#
# This program requires host, perl and lynx to do the dirty work. You *must*
# configure the options below to make this work. Once the defaults are set,
# you can specify the host name and wildcard option through the environment
# variables DYNDNS and DYNWILD, e.g.
#
#    $ DYNHOST=myhost.homeip.net DNSWILD=ON update-dyndns
# -or-
#    % env DYNHOST=anotherhost.dnsalias.com update-dns
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Unless you absolutely *require* a proxy, don't use one with dyndns
unset http_proxy

# Set the username and password for the dyndns account
USERNAME=$1
PASSWORD=$2

# Set the system being used to either static or dynamic DNS
SYSTEM=dyndns
#SYSTEM=statdns

# Set the hostname for the record to change
DYNHOST=$3

# Set whether to wildcard the DNS entry, i.e. *.$DYNHOST
WILDCARD=OFF
#WILDCARD=ON

############################################
## DO NOT EDIT ANYTHING BEYOND THIS POINT ##
############################################

if [ -z "$DYNDNS" ]; then
    DYNDNS="$DYNHOST"
fi

if [ -z "$DNSWILD"]; then
    DNSWILD="$WILDCARD"
fi

LOOKUP=`/usr/bin/nslookup $DYNHOST | grep -o 'Address 1:.*$DYNHOST' | cut -d ' ' -f 3`
MYIP=`/sbin/ifconfig wlan0 | grep inet | perl -ple '($_) = /addr:([^ ]+)/'`

# Do the work
if [ "$LOOKUP" = "$MYIP" ]; then
    echo "No change in DNS entry."
else
    echo `lynx -auth=${USERNAME}:${PASSWORD} -source "http://members.dyndns.org:8245/nic/update?system=${SYSTEM}&hostname=${DYNDNS}&myip=${MYIP}&wildcard=${DNSWILD}"`
fi
