#!/bin/sh

# Run passed command with its arguments with 'user' privileges
# This file is part of 'Maemo Wi-Fi Connection Handler' project
# Please visit http://thekondor.net/conler for details

gtk_theme_file=/home/user/.osso/current-gtk-theme

export DEFAULTMBTHEME=glasser
if [ -e $gtk_theme_file ]; then
    export DEFAULTMBTHEME=`cat $gtk_theme_file | /usr/bin/cut -d / -f 5` 
fi

export DEFAULTGTKTHEME="default"
export DISABLE_GATEWAY="1"
export DISPLAY=":0.0"
export GTK2_RC_FILES="/home/user/.osso/current-gtk-theme:/home/user/.osso/current-gtk-key-theme"
export DBUS_SESSION_BUS_ADDRESS="unix:path=/tmp/session_bus_socket"


if [ 0 -eq $# ]; then
    echo "No arguments are passed"
    exit 1
fi

# Execute passed command
/bin/su -l user -c "$@"


