/*
 * Copyright (C) 2008, 2009 Andrew Sichevoi.
 *
 * This file is part of Conler (http://thekondor.net/conler).
 *
 * Conler is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conler. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CONLER_UI_UTILS_H
#define _CONLER_UI_UTILS_H

#include <gtk/gtk.h>

gboolean get_current_tree_iter(GtkTreeView*, GtkTreeModel**, GtkTreeIter*);
gboolean is_next_tree_iter_sibling(GtkTreeModel*, GtkTreeIter*);
gboolean is_prev_tree_iter_sibling(GtkTreeModel*, GtkTreeIter*);
GtkTreeIter* get_next_tree_iter(GtkTreeModel*, GtkTreeIter*);
GtkTreeIter* get_prev_tree_iter(GtkTreeModel*, GtkTreeIter*);
gchar* tree_iter_to_path_string(GtkTreeModel*, GtkTreeIter*);
gboolean path_string_to_tree_iter(GtkTreeModel*, gchar*, GtkTreeIter*);
gboolean swap_list_store_items(GtkTreeModel*, GtkTreeIter*, const gboolean);

GtkWidget* show_add_or_edit_entity_basic_dialog(GtkWindow*,
						gchar*, gchar*, gchar*,
						GtkWidget* input_hbox, ...);

void resize_window_by_delta(GtkWindow*, gint, gint);
GtkWidget* make_label_with_markup(const gchar*);
GtkWidget* make_check_button(const gchar*, gboolean);

#define SET_STOCK_ICON(obj, condition, icon1, icon2) \
  g_object_set(obj, "stock-id", (condition) ? GTK_STOCK_ ## icon1 :\
                                              GTK_STOCK_ ## icon2, NULL)


#endif

