/*
 * Copyright (C) 2008, 2009 Andrew Sichevoi.
 *
 * This file is part of Conler (http://thekondor.net/conler).
 *
 * Conler is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conler. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CONLER_DEBUG_H
#define _CONLER_DEBUG_H

#include <glib/gstdio.h>

#ifdef DEBUG
 #define DBG(...) g_debug(__VA_ARGS__)

 #if DEBUG >= 2
   #define DBG2(...) DBG("V: " __VA_ARGS__)
 #else
   #define DBG2(...)
 #endif

 #if DEBUG >= 3
   #define DBG3(...) DBG("VV: " __VA_ARGS__)
 #else
   #define DBG3(...)
 #endif

 #define creturn(value, ...) { DBG(__VA_ARGS__); return value; }
 #define ccreturn(...) { DBG(__VA_ARGS__); return; }

#else
 #define DBG(...)
 #define DBG1(...)
 #define DBG2(...)

 #define creturn(value, ...)    return value
 #define ccreturn(...)          return
#endif


/* Component-specific debug print statements */
#if defined(DEBUG) && defined(CONFIG_WRITE_DBG)
  #define CFG_DBG(...)  DBG(__VA_ARGS__)
#else
  #define CFG_DBG(...)
#endif

#endif

