/*
 * Copyright (C) 2008, 2009 Andrew Sichevoi.
 *
 * This file is part of Conler (http://thekondor.net/conler).
 *
 * Conler is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conler. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CONLER_CONST_H
#define _CONLER_CONST_H

#ifdef DEBUG
  #define VERSION_POSTFIX     "-debug"
#else
  #define VERSION_POSTFIX     ""
#endif

#define PROGRAM_ID          "conler"
#define PROGRAM_FULL_ID     "Connection Handler"
#define PROGRAM_VERSION     "0.1.2b" VERSION_POSTFIX
#define COPYRIGHT           "(c) Andrew Sichevoi, http://thekondor.net/conler"

#ifndef CONFIG_PATH
  #define CONFIG_PATH         "/home/user/.config/conler.xml"
#endif

/* Maemo/GUI specific */
#define DIABLO_IDENT          "DIABLO"
#define OSSO_SOFTWARE_VERSION "/etc/osso_software_version"

#ifdef CONLER_GUI
  #define OSSO_SERVICE_NAME     "com.thekondor.conler"
  #define HELP_TOPIC_ID         "help_conler_intro"

  #ifndef PIXMAP_DIR
     #define PIXMAP_DIR "/usr/share/pixmaps/conler"
  #endif
#endif

/* Configuration keywords */
#define ROOT_CFG_ELEMENT    "conler-config"
#define APS_CFG_ELEMENT     "access-points"
#define AP_CFG_ELEMENT      "access-point"
#define CMDS_CFG_ELEMENT    "commands"
#define CMD_CFG_ELEMENT     "command"

#define VERSION_CFG_ATTR       "version"
#define NAME_CFG_ATTR          "name"
#define DISABLED_CFG_ATTR      "disabled"
#define SUPERUSER_ENV_CFG_ATTR "superuser_env"

#define TRUE_BOOL           "true"


/* Configuration reading statuses */
#if defined __GNUC__
#define UNUSED_WARN_OFF __attribute__ ((unused))
#else
#define UNUSED_WARN_OFF
#endif

static const char* CFG_READ_STATUS[] UNUSED_WARN_OFF = {
                                         "No errors",
                                         "Open error",
                                         "Empty file",
                                         "Wrong format/type"
                                       };


/* Default name of unnamed AP */
#define UNKNOWN_AP_FMT      "unknown%u"


#endif

