/*
 * Copyright (C) 2008, 2009 Andrew Sichevoi.
 *
 * This file is part of Conler (http://thekondor.net/conler).
 *
 * Conler is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conler. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CONLER_COMMON_H
#define _CONLER_COMMON_H

#include <glib/gstdio.h>

#include "types.h"

#define AP_CAST(data)       ((AccessPoint_s *)(data))
#define AP_LIST_CAST(list)  AP_CAST(list->data)

#define CMD_CAST(data)      ((Command_s *)(data))
#define CMD_LIST_CAST(list) CMD_CAST(list->data)

#define APPEND2SLIST(lst, item)  lst = g_slist_append(lst, item)

MaemoVersion get_maemo_version();

CfgReadResult read_cfg(const gchar* const, ConlerCfg_s*);
gboolean write_cfg(const gchar* const, const ConlerCfg_s* const);
void     free_cfg(ConlerCfg_s*);

void free_command_list(GSList*);
void free_command(Command_s*);
Command_s* copy_command(Command_s*);

void free_access_point(AccessPoint_s*);
AccessPoint_s* copy_access_point(AccessPoint_s*);

#ifdef DEBUG
void dump_ap(gchar*, AccessPoint_s*, gboolean);
void dump_commands(gchar*, GSList*);
#endif

#endif

