/*
 * Copyright (C) 2008, 2009 Andrew Sichevoi.
 *
 * This file is part of Conler (http://thekondor.net/conler).
 *
 * Conler is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conler. If not, see <http://www.gnu.org/licenses/>.
 */

/* FEATURE:
 *   if 'stock-id' is 0 and 'activate' signal is emitted,
 *   handlers are NOT called,
 *   only MOUSE events are handled to emit the signal
 */

#ifndef _CONLER_CELL_RENDERER_PIXBUF_H
#define _CONLER_CELL_RENDERER_PIXBUF_H

#include <gtk/gtkcellrendererpixbuf.h>

G_BEGIN_DECLS

#define TYPE_CELL_RENDERER_PIXBUF           (cell_renderer_pixbuf_get_type())
#define CELL_RENDERER_PIXBUF(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),\
                                             TYPE_CELL_RENDERER_PIXBUF,\
                                             CellRendererPixbuf))
#define CELL_RENDERER_PIXBUF_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),\
                                             TYPE_CELL_RENDERER_PIXBUF,\
                                             CellRendererPixbufClass))
#define IS_CELL_RENDERER_PIXBUF(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),\
                                             TYPE_CELL_RENDERER_PIXBUF))
#define IS_CELL_RENDERER_PIXBUF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),\
                                              TYPE_CELL_RENDERER_PIXBUF))
#define CELL_RENDERER_PIXBUF_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),\
                                              TYPE_CELL_RENDERER_PIXBUF,\
                                              CellRendererPixbufClass))
                                                 


typedef struct _CellRendererPixbuf CellRendererPixbuf;
typedef struct _CellRendererPixbufClass CellRendererPixbufClass;


struct _CellRendererPixbuf
{
    GtkCellRendererPixbuf parent;
};

struct _CellRendererPixbufClass
{
    GtkCellRendererPixbufClass parent_class;
    void (* activate)(CellRendererPixbuf* cell, const gchar* path);
};


GType                     cell_renderer_pixbuf_get_type(void);
GtkCellRenderer*          cell_renderer_pixbuf_new(void);


G_END_DECLS

#endif

