// (c) 2008, Andrew V. Sichevoi
// http://thekondor.net/conler

#include "ui-utils.h"

#include <gtk/gtk.h>
#include <glib/glist.h>

gboolean is_next_tree_iter_sibling(GtkTreeModel* model, GtkTreeIter* iter)
{
    GtkTreeIter* next_iter = gtk_tree_iter_copy(iter);
    gboolean next = gtk_tree_model_iter_next(model, next_iter);

    gtk_tree_iter_free(next_iter);

    return next;
}

gboolean is_prev_tree_iter_sibling(GtkTreeModel* model, GtkTreeIter* iter)
{
    GtkTreePath* path = gtk_tree_model_get_path(model, iter);
    gboolean prev = gtk_tree_path_prev(path);

    gtk_tree_path_free(path);

    return prev;
}

GtkTreeIter* get_next_tree_iter(GtkTreeModel* model, GtkTreeIter* iter)
{
    GtkTreeIter* next_iter = gtk_tree_iter_copy(iter);
    gboolean next = gtk_tree_model_iter_next(model, next_iter);

    if (next)
        return next_iter;

    gtk_tree_iter_free(next_iter);
    return NULL;
}

GtkTreeIter* get_prev_tree_iter(GtkTreeModel* model, GtkTreeIter* iter)
{
    GtkTreePath* path = gtk_tree_model_get_path(model, iter);
    gboolean prev = gtk_tree_path_prev(path);
    GtkTreeIter* next_iter;

    if (!prev) {
        gtk_tree_path_free(path);
        return NULL;
    }

    // Looks dirty because of stupid API
    next_iter = gtk_tree_iter_copy(iter);
    if (!gtk_tree_model_get_iter(model, next_iter, path)) {
        gtk_tree_iter_free(next_iter);
        gtk_tree_path_free(path);
        return NULL;
    }

    gtk_tree_path_free(path);

    return next_iter;
}

gchar* tree_iter_to_path_string(GtkTreeModel* model, GtkTreeIter* iter)
{
    GtkTreePath* path = gtk_tree_model_get_path(model, iter);
    gchar* path_string = gtk_tree_path_to_string(path);

    gtk_tree_path_free(path);

    return path_string;
}

gboolean path_string_to_tree_iter(GtkTreeModel* model, gchar* path_string,
                                                       GtkTreeIter* iter)
{
    GtkTreePath* path = gtk_tree_path_new_from_string(path_string);
    gboolean result = TRUE;

    if (!gtk_tree_model_get_iter(model, iter, path))
        result = FALSE;

    gtk_tree_path_free(path);

    return result;
}

/* if prev is FALSE, swapping is performed in the back direction */
gboolean swap_list_store_items(GtkTreeModel* tree_model, GtkTreeIter* iter,
                                                         const gboolean prev)
{
    GtkTreeIter* neighbour_iter;

    if (prev)
        neighbour_iter = get_prev_tree_iter(tree_model, iter);
    else
        neighbour_iter = get_next_tree_iter(tree_model, iter);

    if (!neighbour_iter)
        return FALSE;

    gtk_list_store_swap(GTK_LIST_STORE(tree_model), iter, neighbour_iter);

    gtk_tree_iter_free(neighbour_iter);

    return TRUE;
}


/* Returned string should be freed on finish */
// TODO: dirty, should be revised
gchar* show_add_entity_input_dialog(GtkWindow* parent,
                                  const gboolean edit,
                                  const gchar* title,
                                  const gchar* entity,
                                  const gchar* initial_value)
{
    GtkWidget* dialog;
    GtkWidget* input_hbox = gtk_hbox_new(FALSE, 0);
    GtkWidget* label = gtk_label_new_with_mnemonic(entity);
    GtkWidget* input_entry = gtk_entry_new();

    if (initial_value)
        gtk_entry_set_text(GTK_ENTRY(input_entry), (gchar *)initial_value);

    dialog = gtk_dialog_new_with_buttons(
                             title, parent,
                             GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                             edit ? "_Edit" : "_Add", GTK_RESPONSE_OK,
                             "_Cancel", GTK_RESPONSE_CANCEL, NULL);

    gtk_dialog_set_default_response(GTK_DIALOG (dialog), GTK_RESPONSE_OK);

    gtk_label_set_mnemonic_widget(GTK_LABEL(label), input_entry);
    gtk_box_pack_start_defaults(GTK_BOX(input_hbox), label);
    gtk_box_pack_start_defaults(GTK_BOX(input_hbox), input_entry);
   
    gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(dialog)->vbox), input_hbox);
    gtk_widget_show_all(dialog);

    gint response = gtk_dialog_run(GTK_DIALOG(dialog));
    gchar* text = (gchar *)gtk_entry_get_text(GTK_ENTRY(input_entry));
    if (GTK_RESPONSE_OK != response || !g_utf8_strlen(text, -1)) {
        gtk_widget_destroy(dialog);
        return NULL;
    }
    
    if (initial_value)
        if (!g_ascii_strcasecmp((const gchar *)text, initial_value)) {
            gtk_widget_destroy(dialog);
            return NULL;
        }


    text = g_strdup(text);

    gtk_widget_destroy(dialog);

    return text;
}

void emit_signal_to_selected_cell(GtkTreeView* tree_view, GtkCellRenderer* cell,
                                    const gchar* signal_name, gpointer data)
                                                  
{
    GtkTreeModel* model = gtk_tree_view_get_model(tree_view);
    GtkTreeSelection* selection = gtk_tree_view_get_selection(tree_view);
    GtkTreeIter iter;
    gchar* path_string;

    if (!gtk_tree_selection_get_selected(selection, &model, &iter)) {
        g_debug("Can't get selection!");
        return;
    }

    path_string = tree_iter_to_path_string(model, &iter);

    g_signal_emit_by_name(G_OBJECT(cell), signal_name, path_string, data);

    g_free(path_string);
}



