// (c) 2008, Andrew V. Sichevoi
// http://thekondor.net/conler

#include "slots.h"
#include "types.h"
#include "common.h"
#include "const.h"
#include "ui.h"
#include "ui-utils.h"
#include "debug.h"

#include <glib-object.h>
#include <glib/gstdio.h>

#include <gtk/gtk.h>

#ifdef MAEMO
  #include <hildon/hildon.h>
  #include <gdk/gdkkeysyms.h>
#endif

#define W(wdg)  app_data->wdg


// static gboolean set_tree_view_cursor(gpointer);

static void connect_toolbutton_signals(AppData_s*);
static void close_application(GtkWidget*, gpointer);
#ifdef MAEMO
  static gboolean key_pressed(GtkWidget*, GdkEventKey*, gpointer);
#endif
static void apply_changes(GtkWidget*, gpointer);
static void ap_disabled_state_changed(GtkCellRenderer*, gchar*, gpointer);
static void ap_name_changed(GtkCellRenderer*, gchar*, gchar*, gpointer);
static void ap_selection_changed(GtkWidget*, gpointer);
static void cmdline_moved_up(GtkCellRenderer*, gchar*, gpointer);
static void cmdline_moved_down(GtkCellRenderer*, gchar*, gpointer);
static void cmdline_changed(GtkCellRenderer*, gchar*, gchar*, gpointer);
static void cmd_selection_changed(GtkWidget*, gpointer);

static void add_ap_toolbutton_clicked(GtkWidget*, gpointer);
static void disable_ap_toolbutton_clicked(GtkWidget*, gpointer);
static void del_ap_toolbutton_clicked(GtkWidget*, gpointer);
static void rename_ap_toolbutton_clicked(GtkWidget*, gpointer);
static void add_cmd_toolbutton_clicked(GtkWidget*, gpointer);
static void del_cmd_toolbutton_clicked(GtkWidget*, gpointer);
static void move_up_cmd_toolbutton_clicked(GtkWidget*, gpointer);
static void move_down_cmd_toolbutton_clicked(GtkWidget*, gpointer);
static void edit_cmd_toolbutton_clicked(GtkWidget*, gpointer);


// TODO: move to utils?
static void update_ap_model_commands(AppData_s*, GtkTreeIter*);


void cursor_changed(GtkTreeView* view, gpointer data)
{
    debug_msg("incredible! cursor changed");
}

void connect_signals(AppData_s* app_data)
{
    g_signal_connect(W(mainWindow), "delete_event",
                     G_CALLBACK(close_application), app_data);

    g_signal_connect(W(mainWindow), "destroy",
                     G_CALLBACK(close_application), app_data);

#ifdef MAEMO
    g_signal_connect(W(mainWindow), "key_press_event",
                     G_CALLBACK(key_pressed), app_data);
#endif

    /* AP */
    g_object_set(W(ap.enabledCellRndr), "mode",
                 GTK_CELL_RENDERER_MODE_ACTIVATABLE, NULL);
    g_signal_connect(W(ap.enabledCellRndr), "activate",
                     G_CALLBACK(ap_disabled_state_changed), app_data);

    g_object_set(W(ap.nameCellRndr), "editable", TRUE, NULL);
    g_signal_connect(W(ap.nameCellRndr), "edited",
                     G_CALLBACK(ap_name_changed), app_data);

    GtkTreeSelection* apListSelection = gtk_tree_view_get_selection(
                                            GTK_TREE_VIEW(W(apListView)));
    g_signal_connect(apListSelection, "changed",
                     G_CALLBACK(ap_selection_changed), app_data);

    /* Command */
    g_object_set(W(cmd.downLineCellRndr), "mode",
                 GTK_CELL_RENDERER_MODE_ACTIVATABLE, NULL);
    g_signal_connect(W(cmd.downLineCellRndr), "activate",
                     G_CALLBACK(cmdline_moved_down), app_data);
   
    g_object_set(W(cmd.upLineCellRndr), "mode",
                 GTK_CELL_RENDERER_MODE_ACTIVATABLE, NULL);
    g_signal_connect(W(cmd.upLineCellRndr), "activate",
                     G_CALLBACK(cmdline_moved_up), app_data);
   
    g_object_set(W(cmd.cmdlineCellRndr), "editable", TRUE, NULL);
    g_signal_connect(W(cmd.cmdlineCellRndr), "edited",
                     G_CALLBACK(cmdline_changed), app_data);

    GtkTreeSelection* cmdListSelection = gtk_tree_view_get_selection(
                                            GTK_TREE_VIEW(W(commandListView)));
    g_signal_connect(cmdListSelection, "changed",
                     G_CALLBACK(cmd_selection_changed), app_data);

//    g_signal_connect(W(commandListView), "cursor-changed",
//                     G_CALLBACK(cursor_changed), NULL);

    connect_toolbutton_signals(app_data);
}

static void connect_toolbutton_signals(AppData_s* app_data)
{
    g_signal_connect(W(quitToolButton), "clicked",
                     G_CALLBACK(close_application), app_data);
    g_signal_connect(W(applyToolButton), "clicked",
                     G_CALLBACK(apply_changes), app_data);

    g_signal_connect(W(ap.disableToolButton), "clicked",
                     G_CALLBACK(disable_ap_toolbutton_clicked), app_data);
    g_signal_connect(W(ap.addToolButton), "clicked",
                     G_CALLBACK(add_ap_toolbutton_clicked), app_data);
    g_signal_connect(W(ap.delToolButton), "clicked",
                     G_CALLBACK(del_ap_toolbutton_clicked), app_data);
    g_signal_connect(W(ap.renameToolButton), "clicked",
                     G_CALLBACK(rename_ap_toolbutton_clicked), app_data);

    g_signal_connect(W(cmd.addToolButton), "clicked",
                     G_CALLBACK(add_cmd_toolbutton_clicked), app_data);
    g_signal_connect(W(cmd.delToolButton), "clicked",
                     G_CALLBACK(del_cmd_toolbutton_clicked), app_data);
    g_signal_connect(W(cmd.moveUpToolButton), "clicked",
                     G_CALLBACK(move_up_cmd_toolbutton_clicked), app_data);
    g_signal_connect(W(cmd.moveDownToolButton), "clicked",
                     G_CALLBACK(move_down_cmd_toolbutton_clicked), app_data);
    g_signal_connect(W(cmd.editToolButton), "clicked",
                     G_CALLBACK(edit_cmd_toolbutton_clicked), app_data);
}

static void ap_disabled_state_changed(GtkCellRenderer* cell_renderer,
                                      gchar* path_string, gpointer data)
{
    GtkTreeIter iter;
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(W(apListView)));
    GtkTreePath* path = gtk_tree_path_new_from_string(path_string);

    if (!gtk_tree_model_get_iter(model, &iter, path)) {
        debug_msg("Can't get the iter\n");
        return;
    }

    AccessPoint_s* ap;
    gtk_tree_model_get(model, &iter, 0, &ap, -1);
    ap->disabled = !ap->disabled;
    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, ap);

    SET_STOCK_ICON(W(ap.disableToolButton), ap->disabled, NO, YES); 

    free_access_point(ap);
    gtk_tree_path_free(path);

    W(changed) = TRUE;
}

static void ap_name_changed(GtkCellRenderer* cell_renderer, gchar* path_string,
                            gchar* new_ap_name, gpointer data)
{
    GtkTreeIter iter;
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(W(apListView)));
    GtkTreePath* path = gtk_tree_path_new_from_string(path_string);

    if (!gtk_tree_model_get_iter(model, &iter, path)) {
        debug_msg("Can't get an iter for current\n");
        return;
    }

    AccessPoint_s* ap;
    gtk_tree_model_get(model, &iter, 0, &ap, -1);
    g_free(ap->name);
    ap->name = g_strdup(new_ap_name);
    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, ap, -1);

    free_access_point(ap);
    gtk_tree_path_free(path);

    W(changed) = TRUE;
}

static void ap_selection_changed(GtkWidget* selection, gpointer data)
{
// TODO: don't process selection if ap-state pixbuf clicked
    GtkTreeModel* model;
    GtkTreeIter iter;
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeModel* cmd_model = gtk_tree_view_get_model(
                                    GTK_TREE_VIEW(W(commandListView)));
    AccessPoint_s* ap;

    if (W(cmd.changed)) {
        W(changed) = TRUE;
        update_ap_model_commands(app_data, W(ap.currentIter));
    }

    /* Use-Case: all APs are deleted */
    if (!gtk_tree_selection_get_selected(GTK_TREE_SELECTION(selection),
                                                         &model, &iter)) {
        enable_ap_general_toolbuttons(app_data, FALSE);
        enable_cmd_toolbuttons(app_data, FALSE);
        return;
    }
    enable_ap_general_toolbuttons(app_data, TRUE);
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.addToolButton)), TRUE);
   
 
//    enable_cmd_toolbuttons(app_data, TRUE);
//    gtk_widget_set_sensitive(gtk_widget(w(cmd.addtoolbutton)), true);
//    enable_ap_general_toolbuttons(app_data, TRUE);
    // TODO: make an alias for gtk_widget_set_sensitive(), e.g.
    //       @define enable_tool_button(toolbutton, enable)

    gtk_tree_model_get(model, &iter, 0, &ap, -1);
    debug_msg("ap = %s\n", ap->name);

    SET_STOCK_ICON(W(ap.disableToolButton), ap->disabled, NO, YES);
    fill_cmd_list_view(GTK_LIST_STORE(cmd_model), ap->commands);

    free_access_point(ap);
    // TODO: what about g_object_unref to the model?

    W(ap.currentIter) = gtk_tree_iter_copy(&iter);
    W(cmd.changed) = FALSE;
}

static void cmd_selection_changed(GtkWidget* selection, gpointer data)
{
    GtkTreeModel* model;
    GtkTreeIter iter;
    AppData_s* app_data = (AppData_s *)data;
    gboolean next_cmd, prev_cmd;

    if (!gtk_tree_selection_get_selected(GTK_TREE_SELECTION(selection),
                                         &model, &iter)) {
        enable_cmd_toolbuttons(app_data, FALSE);
        gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.addToolButton)), TRUE);
        return;
    }

    enable_cmd_toolbuttons(app_data, TRUE);

    next_cmd = is_next_tree_iter_sibling(model, &iter);
    prev_cmd = is_prev_tree_iter_sibling(model, &iter);

    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.moveDownToolButton)), next_cmd);
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.moveUpToolButton)), prev_cmd);
}


static void cmdline_moved_up(GtkCellRenderer* cell, gchar* path_string,
                                                      gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeIter iter;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                       W(commandListView)));

    if (!path_string_to_tree_iter(model, path_string, &iter)) {
        debug_msg("Can't get an iter for current");
        return;
    }

    (void)swap_list_store_items(model, &iter, TRUE);

    W(cmd.changed) = TRUE;
}


static void cmdline_moved_down(GtkCellRenderer* cell, gchar* path_string,
                                                      gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeIter iter;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                       W(commandListView)));

    debug_msg("Action: move down");

    if (!path_string_to_tree_iter(model, path_string, &iter)) {
        debug_msg("Can't get an iter for current");
        return;
    }

    (void)swap_list_store_items(model, &iter, FALSE);

    W(cmd.changed) = TRUE;
}



static void cmdline_changed(GtkCellRenderer* cell_renderer, gchar* path_string,
                            gchar* new_cmd, gpointer data)
{
    GtkTreeIter iter;
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                    W(commandListView)));
    GtkTreePath* path = gtk_tree_path_new_from_string(path_string);

    if (!gtk_tree_model_get_iter(model, &iter, path)) {
        debug_msg("Can't get an iter for current\n");
        return;
    }

    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, new_cmd, -1);

    gtk_tree_path_free(path);

    W(cmd.changed) = TRUE;
}


/* Makes synchronization between commands in commandListView and AP model */
static void update_ap_model_commands(AppData_s* app_data, GtkTreeIter* ap_iter)
{
    GtkTreeModel* ap_model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                        W(apListView)));
    GtkTreeModel* cmd_model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                        W(commandListView)));
    AccessPoint_s* ap = NULL;

    gtk_tree_model_get(ap_model, ap_iter, 0, &ap, -1);
    free_command_list(ap->commands);
    ap->commands = get_cmd_gslist_from_model(cmd_model);

    for (GSList* iter = ap->commands; iter; iter = g_slist_next(iter))
        debug_msg("* cmd = %s", (gchar *)(iter->data));

    gtk_list_store_set(GTK_LIST_STORE(ap_model), ap_iter, 0, ap, -1);

    free_access_point(ap);

    debug_msg("Sync AP Model <-> commandListView");
}

static void add_ap_toolbutton_clicked(GtkWidget* widget, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                    W(apListView)));
    GtkTreeIter iter;
    gchar* ap_name;
    AccessPoint_s* ap;

    ap_name = show_add_entity_input_dialog(GTK_WINDOW(W(mainWindow)), FALSE,
                                         "New Access Point", "A_P Name:", NULL);
    if (!ap_name)
        return;

    ap = g_new(AccessPoint_s, 1);
    ap->name = ap_name;
    ap->disabled = TRUE;
    ap->commands = NULL;

    gtk_list_store_append(GTK_LIST_STORE(model), &iter);
    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, ap, -1);

    select_treeview_row(W(apListView), &iter);

    free_access_point(ap);

    W(changed) = TRUE;
}

static void del_ap_toolbutton_clicked(GtkWidget* widget, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                        W(apListView)));
    GtkTreeModel* cmd_model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                        W(commandListView)));
    GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(
                                                               W(apListView)));
    GtkTreeIter iter;
    GtkTreeIter* neighbour_iter;

    if (!gtk_tree_selection_get_selected(selection, &model, &iter)) {
        debug_msg("Can't get selection!");
        return;
    }

    neighbour_iter = get_next_tree_iter(model, &iter);
    if (!neighbour_iter)
        neighbour_iter = get_prev_tree_iter(model, &iter);

    gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
    gtk_list_store_clear(GTK_LIST_STORE(cmd_model));

    if (neighbour_iter) {
        select_treeview_row(W(apListView), neighbour_iter);
        gtk_tree_iter_free(neighbour_iter);
    }

    W(changed) = TRUE;
}

static void disable_ap_toolbutton_clicked(GtkWidget* widget, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                    W(apListView)));
    GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(
                                                    W(apListView)));
    GtkTreeIter iter;
    gchar* path_string;

    if (!gtk_tree_selection_get_selected(selection, &model, &iter)) {
        debug_msg("Can't get selection!");
        return;
    }

    path_string = tree_iter_to_path_string(model, &iter);

    g_signal_emit_by_name(G_OBJECT(W(ap.enabledCellRndr)), "activate",
                                                  path_string, data);

    g_free(path_string);
}

static void rename_ap_toolbutton_clicked(GtkWidget* widget, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeModel* model = gtk_tree_view_get_model(
                                            GTK_TREE_VIEW(W(apListView)));
    GtkTreeSelection* selection = gtk_tree_view_get_selection(
                                            GTK_TREE_VIEW(W(apListView)));
    GtkTreeIter iter;
    AccessPoint_s* ap;
    gchar* new_ap_name;

    if (!gtk_tree_selection_get_selected(selection, &model, &iter)) {
        debug_msg("Can't get selection!");
        return;
    }

    gtk_tree_model_get(model, &iter, 0, &ap, -1);
    new_ap_name = show_add_entity_input_dialog(GTK_WINDOW(W(mainWindow)), TRUE,
                                                              "Rename Access Point",
                                                              "_AP:",
                                                              ap->name);
    if (!new_ap_name) {
        free_access_point(ap);
        return;
    }

    ap->name = new_ap_name;

    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, ap, -1);

    free_access_point(ap);

    W(changed) = TRUE;
}


static void add_cmd_toolbutton_clicked(GtkWidget* widget, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                    W(commandListView)));
    GtkTreeIter iter;
    gchar* cmd;

    cmd = show_add_entity_input_dialog(GTK_WINDOW(W(mainWindow)), FALSE,
                                       "New Command", "_Command:", NULL);
    if (!cmd)
        return;

    gtk_list_store_append(GTK_LIST_STORE(model), &iter);
    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, cmd, -1);

    select_treeview_row(W(commandListView), &iter);

    g_free(cmd);

    W(cmd.changed) = TRUE;
}

// TODO: remove copy&paste; similar code in 'del_ap_toolbutton_clicked'
static void del_cmd_toolbutton_clicked(GtkWidget* widget, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                    W(commandListView)));
    GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(
                                                          W(commandListView)));
    GtkTreeIter iter;
    GtkTreeIter* next_iter;

    if (!gtk_tree_selection_get_selected(selection, &model, &iter)) {
        debug_msg("Can't get selection!");
        return;
    }

    next_iter = get_next_tree_iter(model, &iter);
    if (!next_iter)
        next_iter = get_prev_tree_iter(model, &iter);

    gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
   
    if (next_iter) {
        select_treeview_row(W(commandListView), next_iter);
        gtk_tree_iter_free(next_iter);
    }

    W(cmd.changed) = TRUE;
}

// TODO: don't like this implementation (w/a). should be revised
static void move_up_cmd_toolbutton_clicked(GtkWidget* widget, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeIter iter;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                       W(commandListView)));
    GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(
                                                       W(commandListView)));

    if (!gtk_tree_selection_get_selected(selection, &model, &iter))
        return;

    (void)swap_list_store_items(model, &iter, TRUE);
    cmd_selection_changed((GtkWidget *)selection, data);

    W(cmd.changed) = TRUE;

/*
    AppData_s* app_data = (AppData_s *)data;
   
    emit_signal_to_selected_cell(GTK_TREE_VIEW(W(commandListView)),
                                 W(cmd.upLineCellRndr), "activate", data);
*/
}

static void move_down_cmd_toolbutton_clicked(GtkWidget* widget, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeIter iter;
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                       W(commandListView)));
    GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(
                                                       W(commandListView)));

    if (!gtk_tree_selection_get_selected(selection, &model, &iter))
        return;

    (void)swap_list_store_items(model, &iter, FALSE);
    cmd_selection_changed((GtkWidget *)selection, data);

    W(cmd.changed) = TRUE;

/*
    AppData_s* app_data = (AppData_s *)data;

    emit_signal_to_selected_cell(GTK_TREE_VIEW(W(commandListView)),
                                 W(cmd.downLineCellRndr), "activate", data);
*/
}

// TODO: remove copy&paste; similar code 'edit_ap_name_toolbutton_clicked'
static void edit_cmd_toolbutton_clicked(GtkWidget* widget, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    GtkTreeModel* model = gtk_tree_view_get_model(
                                            GTK_TREE_VIEW(W(commandListView)));
    GtkTreeSelection* selection = gtk_tree_view_get_selection(
                                            GTK_TREE_VIEW(W(commandListView)));
    GtkTreeIter iter;

    gchar* edited_cmd;
    gchar* current_cmd;

    if (!gtk_tree_selection_get_selected(selection, &model, &iter)) {
        debug_msg("Can't get selection!");
        return;
    }

    gtk_tree_model_get(model, &iter, 0, &current_cmd, -1);
    edited_cmd = show_add_entity_input_dialog(GTK_WINDOW(W(mainWindow)), TRUE,
                                                              "Edit command",
                                                              "_Command:",
                                                              current_cmd);
    g_free(current_cmd);
    if (!edited_cmd)
        return;

    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, edited_cmd, -1);
    g_free(edited_cmd);

    W(cmd.changed) = TRUE;
}

#ifdef MAEMO
static gboolean key_pressed(GtkWidget* widget, GdkEventKey* event, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    switch (event->keyval) {
        case GDK_F6:
                    W(fullscreen) = !(W(fullscreen));
                    if (!(W(fullscreen)))
                        gtk_window_unfullscreen(GTK_WINDOW(W(mainWindow)));
                    else
                        gtk_window_fullscreen(GTK_WINDOW(W(mainWindow)));

                    return TRUE;
    }

    return FALSE;
}
#endif

static void close_application(GtkWidget* widget, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;

    if (W(changed) || W(cmd.changed)) {
        // TODO: make Ok, No, Cancel buttons
        gint response;
        GtkWidget* confirm_save_dialog = gtk_message_dialog_new(
                                        GTK_WINDOW(W(mainWindow)),
                                        GTK_DIALOG_MODAL,
                                        GTK_MESSAGE_QUESTION,
                                        GTK_BUTTONS_YES_NO,
                                        "Save changes before exit?");
        gtk_window_set_title(GTK_WINDOW(confirm_save_dialog), "Save Changes?");

        response = gtk_dialog_run(GTK_DIALOG(confirm_save_dialog));
        if (GTK_RESPONSE_YES == response)
            apply_changes(NULL, data);

        gtk_widget_destroy(confirm_save_dialog);
    }

    gtk_main_quit();
}

static void apply_changes(GtkWidget* widget, gpointer data)
{
    AppData_s* app_data = (AppData_s *)data;
    ConlerCfg_s cfg;
    GtkTreeModel* ap_model = gtk_tree_view_get_model(GTK_TREE_VIEW(
                                                        W(apListView)));

    if (!W(changed) && !W(cmd.changed)) { 
        debug_msg("NO SAVE is required");
        return;
    }

    /* Use-Case: commands has been updated:
     *   - No other AP has not been selected
     *   - Save/Quit button has been pressed after changes
     */
//   if (W(cmd.changed) && !W(changed))
    // TODO: not optimal, research
    if (W(cmd.changed))
        update_ap_model_commands(app_data, W(ap.currentIter));

    cfg.version = g_strdup(PROGRAM_VERSION);
    cfg.access_points = get_ap_gslist_from_model(ap_model);
#ifdef DEBUG
    debug_msg("To save:");
    for (GSList* iter = cfg.access_points; iter; iter = g_slist_next(iter)) {
        AccessPoint_s* ap = AP_LIST_CAST(iter);
        debug_msg(" name = %s, dsb = %s", ap->name, ap->disabled ? "yes" : "no");

        for (GSList* cmd = ap->commands; cmd; cmd = g_slist_next(cmd))
            debug_msg("   cmd = %s", (gchar *)(cmd->data));
    }
#endif
    write_cfg(CONFIG_PATH, &cfg);
    free_cfg(&cfg);

#ifdef MAEMO
    hildon_banner_show_information(GTK_WIDGET(W(mainWindow)), NULL,
                                   "Configuration saved");
#endif

    debug_msg("*** SAVE CONFIGURATION FILE ***");

    W(changed) = FALSE;
    W(cmd.changed) = FALSE;
}


