// (c) 2008, Andrew V. Sichevoi
// http://thekondor.net/conler

#include "ui.h"
#include "slots.h"
#include "common.h"
#include "types.h"
#include "const.h"
#include "appdata.h"

#include <glib/gstdio.h>
#include <glib/gmem.h>

#include <gtk/gtk.h>

#include <stdlib.h>


int main(int argc, char** argv)
{
    ConlerCfg_s cfg;
    AppData_s* app_data;

    gtk_init(&argc, &argv);

    g_set_application_name(PROGRAM_FULL_ID);

    // TODO: create a new configuration file if doesn't exist
    // TODO: accept an alternative path to configuration file
    if (!read_cfg(CONFIG_PATH, &cfg)) {
        GtkWidget* config_error_dialog = gtk_message_dialog_new(NULL,
                                                           GTK_DIALOG_MODAL,
                                                           GTK_MESSAGE_ERROR,
                                                           GTK_BUTTONS_OK,
                                                           "Can't load '%s'",
                                                           CONFIG_PATH);
        gtk_window_set_title(GTK_WINDOW(config_error_dialog), PROGRAM_ID " error");
        gtk_dialog_run(GTK_DIALOG(config_error_dialog));
        gtk_widget_destroy(config_error_dialog);

        exit(1);
    }

    app_data = new_app_data();
    app_data->access_points = cfg.access_points;

    create_main_view(app_data);
    create_ap_list_view(app_data);
    fill_ap_list_view(app_data);
    create_cmd_list_view(app_data);
    enable_cmd_toolbuttons(app_data, FALSE);
//    enable_ap_general_toolbuttons(app_data, FALSE);
    
    connect_signals(app_data);
    gtk_widget_show_all(GTK_WIDGET(app_data->mainWindow));

    gtk_main();

    free_app_data(app_data);
    free_cfg(&cfg);

    return 0;
}

