// (c) 2008, Andrew V. Sichevoi
// http://thekondor.net/conler

#ifndef _CONLER_COMMON_H
#define _CONLER_COMMON_H

#include <glib/gstdio.h>

#include "types.h"

#ifdef DEBUG
  #define DBG(...) g_debug(__VA_ARGS__)
#else
  #define DBG(...)
#endif

#define AP_CAST(data)       ((AccessPoint_s *)(data))
#define AP_LIST_CAST(list)  AP_CAST(list->data)

#define APPEND2SLIST(lst, item)  lst = g_slist_append(lst, item)

MaemoVersion get_maemo_version();

gboolean read_cfg(const gchar* const, ConlerCfg_s*);
gboolean write_cfg(const gchar* const, const ConlerCfg_s* const);
void     free_cfg(ConlerCfg_s*);

void free_command_list(GSList*);

void free_access_point(AccessPoint_s*);
AccessPoint_s* copy_access_point(AccessPoint_s*);

#endif

