// (c) 2008, Andrew V. Sichevoi
// http://thekondor.net/conler

#ifndef _CONLER_APPDATA_H
#define _CONLER_APPDATA_H

#include <glib/gslist.h>
#include <gtk/gtk.h>

#ifdef MAEMO
  #include <hildon/hildon.h>
#endif

// #include "types.h"

typedef struct
{
#ifdef MAEMO
    HildonProgram* program;
    HildonWindow* mainWindow;
// TODO; make viewFlags instead with bit mask
    gboolean fullscreen;
#else
    GtkWidget* mainWindow;
#endif

    GtkWidget* apListView;
    GtkWidget* commandListView;

    /* Buttons */
    GtkToolItem* quitToolButton;
    GtkToolItem* applyToolButton;

    /* Data */
    GSList* access_points;

    /* State */
    gboolean changed;

    /* Satellitic Widgets */
    struct
    {
        GtkCellRenderer* enabledCellRndr;
        GtkCellRenderer* nameCellRndr;
        GtkTreeIter* currentIter;

        GtkToolItem* disableToolButton;
        GtkToolItem* addToolButton;
        GtkToolItem* delToolButton;
        GtkToolItem* renameToolButton;
    } ap;

    struct
    {
        GtkCellRenderer* cmdlineCellRndr;
        GtkCellRenderer* downLineCellRndr;
        GtkCellRenderer* upLineCellRndr;

        GtkToolItem* moveUpToolButton;
        GtkToolItem* moveDownToolButton;
        GtkToolItem* addToolButton;
        GtkToolItem* delToolButton;
        GtkToolItem* editToolButton;

        /* Indicates if command list was changed */
        gboolean changed;
    } cmd;

} AppData_s;


#endif

