/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
#ifndef Types_TYPES_H
#define Types_TYPES_H

#include <Thrift.h>
#include <protocol/TProtocol.h>
#include <transport/TTransport.h>

#include "Limits_types.h"


namespace evernote { namespace edam {

enum PrivilegeLevel {
  NORMAL = 1,
  PREMIUM = 3,
  MANAGER = 7,
  SUPPORT = 8,
  ADMIN = 9
};

enum QueryFormat {
  USER = 1,
  SEXP = 2
};

enum NoteSortOrder {
  CREATED = 1,
  UPDATED = 2,
  RELEVANCE = 3,
  UPDATE_SEQUENCE_NUMBER = 4
};

enum PremiumOrderStatus {
  NONE = 0,
  PENDING = 1,
  ACTIVE = 2,
  FAILED = 3,
  CANCELLATION_PENDING = 4,
  CANCELED = 5
};

typedef int32_t UserID;

typedef std::string Guid;

typedef int64_t Timestamp;

class Data {
 public:

  static const char* ascii_fingerprint; // = "BAAB2C3118BDB468C051932BB163B2AF";
  static const uint8_t binary_fingerprint[16]; // = {0xBA,0xAB,0x2C,0x31,0x18,0xBD,0xB4,0x68,0xC0,0x51,0x93,0x2B,0xB1,0x63,0xB2,0xAF};

  Data() : bodyHash(""), size(0), body("") {
  }

  virtual ~Data() throw() {}

  std::string bodyHash;
  int32_t size;
  std::string body;

  struct __isset {
    __isset() : bodyHash(false), size(false), body(false) {}
    bool bodyHash;
    bool size;
    bool body;
  } __isset;

  bool operator == (const Data & rhs) const
  {
    if (__isset.bodyHash != rhs.__isset.bodyHash)
      return false;
    else if (__isset.bodyHash && !(bodyHash == rhs.bodyHash))
      return false;
    if (__isset.size != rhs.__isset.size)
      return false;
    else if (__isset.size && !(size == rhs.size))
      return false;
    if (__isset.body != rhs.__isset.body)
      return false;
    else if (__isset.body && !(body == rhs.body))
      return false;
    return true;
  }
  bool operator != (const Data &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Data & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class UserAttributes {
 public:

  static const char* ascii_fingerprint; // = "403ADED353066420B5EAA1E33867A8BC";
  static const uint8_t binary_fingerprint[16]; // = {0x40,0x3A,0xDE,0xD3,0x53,0x06,0x64,0x20,0xB5,0xEA,0xA1,0xE3,0x38,0x67,0xA8,0xBC};

  UserAttributes() : defaultLocationName(""), defaultLatitude(0), defaultLongitude(0), preactivation(0), incomingEmailAddress(""), comments(""), dateAgreedToTermsOfService(0), maxReferrals(0), referralCount(0), refererCode(""), sentEmailDate(0), sentEmailCount(0), dailyEmailLimit(0), emailOptOutDate(0), partnerEmailOptInDate(0), preferredLanguage(""), preferredCountry(""), clipFullPage(0), twitterUserName(""), twitterId(""), groupName(""), recognitionLanguage("") {
  }

  virtual ~UserAttributes() throw() {}

  std::string defaultLocationName;
  double defaultLatitude;
  double defaultLongitude;
  bool preactivation;
  std::vector<std::string>  viewedPromotions;
  std::string incomingEmailAddress;
  std::vector<std::string>  recentMailedAddresses;
  std::string comments;
  Timestamp dateAgreedToTermsOfService;
  int32_t maxReferrals;
  int32_t referralCount;
  std::string refererCode;
  Timestamp sentEmailDate;
  int32_t sentEmailCount;
  int32_t dailyEmailLimit;
  Timestamp emailOptOutDate;
  Timestamp partnerEmailOptInDate;
  std::string preferredLanguage;
  std::string preferredCountry;
  bool clipFullPage;
  std::string twitterUserName;
  std::string twitterId;
  std::string groupName;
  std::string recognitionLanguage;

  struct __isset {
    __isset() : defaultLocationName(false), defaultLatitude(false), defaultLongitude(false), preactivation(false), viewedPromotions(false), incomingEmailAddress(false), recentMailedAddresses(false), comments(false), dateAgreedToTermsOfService(false), maxReferrals(false), referralCount(false), refererCode(false), sentEmailDate(false), sentEmailCount(false), dailyEmailLimit(false), emailOptOutDate(false), partnerEmailOptInDate(false), preferredLanguage(false), preferredCountry(false), clipFullPage(false), twitterUserName(false), twitterId(false), groupName(false), recognitionLanguage(false) {}
    bool defaultLocationName;
    bool defaultLatitude;
    bool defaultLongitude;
    bool preactivation;
    bool viewedPromotions;
    bool incomingEmailAddress;
    bool recentMailedAddresses;
    bool comments;
    bool dateAgreedToTermsOfService;
    bool maxReferrals;
    bool referralCount;
    bool refererCode;
    bool sentEmailDate;
    bool sentEmailCount;
    bool dailyEmailLimit;
    bool emailOptOutDate;
    bool partnerEmailOptInDate;
    bool preferredLanguage;
    bool preferredCountry;
    bool clipFullPage;
    bool twitterUserName;
    bool twitterId;
    bool groupName;
    bool recognitionLanguage;
  } __isset;

  bool operator == (const UserAttributes & rhs) const
  {
    if (__isset.defaultLocationName != rhs.__isset.defaultLocationName)
      return false;
    else if (__isset.defaultLocationName && !(defaultLocationName == rhs.defaultLocationName))
      return false;
    if (__isset.defaultLatitude != rhs.__isset.defaultLatitude)
      return false;
    else if (__isset.defaultLatitude && !(defaultLatitude == rhs.defaultLatitude))
      return false;
    if (__isset.defaultLongitude != rhs.__isset.defaultLongitude)
      return false;
    else if (__isset.defaultLongitude && !(defaultLongitude == rhs.defaultLongitude))
      return false;
    if (__isset.preactivation != rhs.__isset.preactivation)
      return false;
    else if (__isset.preactivation && !(preactivation == rhs.preactivation))
      return false;
    if (__isset.viewedPromotions != rhs.__isset.viewedPromotions)
      return false;
    else if (__isset.viewedPromotions && !(viewedPromotions == rhs.viewedPromotions))
      return false;
    if (__isset.incomingEmailAddress != rhs.__isset.incomingEmailAddress)
      return false;
    else if (__isset.incomingEmailAddress && !(incomingEmailAddress == rhs.incomingEmailAddress))
      return false;
    if (__isset.recentMailedAddresses != rhs.__isset.recentMailedAddresses)
      return false;
    else if (__isset.recentMailedAddresses && !(recentMailedAddresses == rhs.recentMailedAddresses))
      return false;
    if (__isset.comments != rhs.__isset.comments)
      return false;
    else if (__isset.comments && !(comments == rhs.comments))
      return false;
    if (__isset.dateAgreedToTermsOfService != rhs.__isset.dateAgreedToTermsOfService)
      return false;
    else if (__isset.dateAgreedToTermsOfService && !(dateAgreedToTermsOfService == rhs.dateAgreedToTermsOfService))
      return false;
    if (__isset.maxReferrals != rhs.__isset.maxReferrals)
      return false;
    else if (__isset.maxReferrals && !(maxReferrals == rhs.maxReferrals))
      return false;
    if (__isset.referralCount != rhs.__isset.referralCount)
      return false;
    else if (__isset.referralCount && !(referralCount == rhs.referralCount))
      return false;
    if (__isset.refererCode != rhs.__isset.refererCode)
      return false;
    else if (__isset.refererCode && !(refererCode == rhs.refererCode))
      return false;
    if (__isset.sentEmailDate != rhs.__isset.sentEmailDate)
      return false;
    else if (__isset.sentEmailDate && !(sentEmailDate == rhs.sentEmailDate))
      return false;
    if (__isset.sentEmailCount != rhs.__isset.sentEmailCount)
      return false;
    else if (__isset.sentEmailCount && !(sentEmailCount == rhs.sentEmailCount))
      return false;
    if (__isset.dailyEmailLimit != rhs.__isset.dailyEmailLimit)
      return false;
    else if (__isset.dailyEmailLimit && !(dailyEmailLimit == rhs.dailyEmailLimit))
      return false;
    if (__isset.emailOptOutDate != rhs.__isset.emailOptOutDate)
      return false;
    else if (__isset.emailOptOutDate && !(emailOptOutDate == rhs.emailOptOutDate))
      return false;
    if (__isset.partnerEmailOptInDate != rhs.__isset.partnerEmailOptInDate)
      return false;
    else if (__isset.partnerEmailOptInDate && !(partnerEmailOptInDate == rhs.partnerEmailOptInDate))
      return false;
    if (__isset.preferredLanguage != rhs.__isset.preferredLanguage)
      return false;
    else if (__isset.preferredLanguage && !(preferredLanguage == rhs.preferredLanguage))
      return false;
    if (__isset.preferredCountry != rhs.__isset.preferredCountry)
      return false;
    else if (__isset.preferredCountry && !(preferredCountry == rhs.preferredCountry))
      return false;
    if (__isset.clipFullPage != rhs.__isset.clipFullPage)
      return false;
    else if (__isset.clipFullPage && !(clipFullPage == rhs.clipFullPage))
      return false;
    if (__isset.twitterUserName != rhs.__isset.twitterUserName)
      return false;
    else if (__isset.twitterUserName && !(twitterUserName == rhs.twitterUserName))
      return false;
    if (__isset.twitterId != rhs.__isset.twitterId)
      return false;
    else if (__isset.twitterId && !(twitterId == rhs.twitterId))
      return false;
    if (__isset.groupName != rhs.__isset.groupName)
      return false;
    else if (__isset.groupName && !(groupName == rhs.groupName))
      return false;
    if (__isset.recognitionLanguage != rhs.__isset.recognitionLanguage)
      return false;
    else if (__isset.recognitionLanguage && !(recognitionLanguage == rhs.recognitionLanguage))
      return false;
    return true;
  }
  bool operator != (const UserAttributes &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const UserAttributes & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class Accounting {
 public:

  static const char* ascii_fingerprint; // = "17421BA589A652E287250D6DFF8D25E1";
  static const uint8_t binary_fingerprint[16]; // = {0x17,0x42,0x1B,0xA5,0x89,0xA6,0x52,0xE2,0x87,0x25,0x0D,0x6D,0xFF,0x8D,0x25,0xE1};

  Accounting() : uploadLimit(0), uploadLimitEnd(0), uploadLimitNextMonth(0), premiumOrderNumber(""), premiumCommerceService(""), premiumServiceStart(0), premiumServiceSKU(""), lastSuccessfulCharge(0), lastFailedCharge(0), lastFailedChargeReason(""), nextPaymentDue(0), premiumLockUntil(0), updated(0), premiumSubscriptionNumber(""), lastRequestedCharge(0) {
  }

  virtual ~Accounting() throw() {}

  int64_t uploadLimit;
  Timestamp uploadLimitEnd;
  int64_t uploadLimitNextMonth;
  PremiumOrderStatus premiumServiceStatus;
  std::string premiumOrderNumber;
  std::string premiumCommerceService;
  Timestamp premiumServiceStart;
  std::string premiumServiceSKU;
  Timestamp lastSuccessfulCharge;
  Timestamp lastFailedCharge;
  std::string lastFailedChargeReason;
  Timestamp nextPaymentDue;
  Timestamp premiumLockUntil;
  Timestamp updated;
  std::string premiumSubscriptionNumber;
  Timestamp lastRequestedCharge;

  struct __isset {
    __isset() : uploadLimit(false), uploadLimitEnd(false), uploadLimitNextMonth(false), premiumServiceStatus(false), premiumOrderNumber(false), premiumCommerceService(false), premiumServiceStart(false), premiumServiceSKU(false), lastSuccessfulCharge(false), lastFailedCharge(false), lastFailedChargeReason(false), nextPaymentDue(false), premiumLockUntil(false), updated(false), premiumSubscriptionNumber(false), lastRequestedCharge(false) {}
    bool uploadLimit;
    bool uploadLimitEnd;
    bool uploadLimitNextMonth;
    bool premiumServiceStatus;
    bool premiumOrderNumber;
    bool premiumCommerceService;
    bool premiumServiceStart;
    bool premiumServiceSKU;
    bool lastSuccessfulCharge;
    bool lastFailedCharge;
    bool lastFailedChargeReason;
    bool nextPaymentDue;
    bool premiumLockUntil;
    bool updated;
    bool premiumSubscriptionNumber;
    bool lastRequestedCharge;
  } __isset;

  bool operator == (const Accounting & rhs) const
  {
    if (__isset.uploadLimit != rhs.__isset.uploadLimit)
      return false;
    else if (__isset.uploadLimit && !(uploadLimit == rhs.uploadLimit))
      return false;
    if (__isset.uploadLimitEnd != rhs.__isset.uploadLimitEnd)
      return false;
    else if (__isset.uploadLimitEnd && !(uploadLimitEnd == rhs.uploadLimitEnd))
      return false;
    if (__isset.uploadLimitNextMonth != rhs.__isset.uploadLimitNextMonth)
      return false;
    else if (__isset.uploadLimitNextMonth && !(uploadLimitNextMonth == rhs.uploadLimitNextMonth))
      return false;
    if (__isset.premiumServiceStatus != rhs.__isset.premiumServiceStatus)
      return false;
    else if (__isset.premiumServiceStatus && !(premiumServiceStatus == rhs.premiumServiceStatus))
      return false;
    if (__isset.premiumOrderNumber != rhs.__isset.premiumOrderNumber)
      return false;
    else if (__isset.premiumOrderNumber && !(premiumOrderNumber == rhs.premiumOrderNumber))
      return false;
    if (__isset.premiumCommerceService != rhs.__isset.premiumCommerceService)
      return false;
    else if (__isset.premiumCommerceService && !(premiumCommerceService == rhs.premiumCommerceService))
      return false;
    if (__isset.premiumServiceStart != rhs.__isset.premiumServiceStart)
      return false;
    else if (__isset.premiumServiceStart && !(premiumServiceStart == rhs.premiumServiceStart))
      return false;
    if (__isset.premiumServiceSKU != rhs.__isset.premiumServiceSKU)
      return false;
    else if (__isset.premiumServiceSKU && !(premiumServiceSKU == rhs.premiumServiceSKU))
      return false;
    if (__isset.lastSuccessfulCharge != rhs.__isset.lastSuccessfulCharge)
      return false;
    else if (__isset.lastSuccessfulCharge && !(lastSuccessfulCharge == rhs.lastSuccessfulCharge))
      return false;
    if (__isset.lastFailedCharge != rhs.__isset.lastFailedCharge)
      return false;
    else if (__isset.lastFailedCharge && !(lastFailedCharge == rhs.lastFailedCharge))
      return false;
    if (__isset.lastFailedChargeReason != rhs.__isset.lastFailedChargeReason)
      return false;
    else if (__isset.lastFailedChargeReason && !(lastFailedChargeReason == rhs.lastFailedChargeReason))
      return false;
    if (__isset.nextPaymentDue != rhs.__isset.nextPaymentDue)
      return false;
    else if (__isset.nextPaymentDue && !(nextPaymentDue == rhs.nextPaymentDue))
      return false;
    if (__isset.premiumLockUntil != rhs.__isset.premiumLockUntil)
      return false;
    else if (__isset.premiumLockUntil && !(premiumLockUntil == rhs.premiumLockUntil))
      return false;
    if (__isset.updated != rhs.__isset.updated)
      return false;
    else if (__isset.updated && !(updated == rhs.updated))
      return false;
    if (__isset.premiumSubscriptionNumber != rhs.__isset.premiumSubscriptionNumber)
      return false;
    else if (__isset.premiumSubscriptionNumber && !(premiumSubscriptionNumber == rhs.premiumSubscriptionNumber))
      return false;
    if (__isset.lastRequestedCharge != rhs.__isset.lastRequestedCharge)
      return false;
    else if (__isset.lastRequestedCharge && !(lastRequestedCharge == rhs.lastRequestedCharge))
      return false;
    return true;
  }
  bool operator != (const Accounting &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Accounting & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class User {
 public:

  static const char* ascii_fingerprint; // = "ED929C5F1884A862976CD120CCB0E4CE";
  static const uint8_t binary_fingerprint[16]; // = {0xED,0x92,0x9C,0x5F,0x18,0x84,0xA8,0x62,0x97,0x6C,0xD1,0x20,0xCC,0xB0,0xE4,0xCE};

  User() : id(0), username(""), email(""), name(""), timezone(""), created(0), updated(0), deleted(0), active(0), shardId("") {
  }

  virtual ~User() throw() {}

  UserID id;
  std::string username;
  std::string email;
  std::string name;
  std::string timezone;
  PrivilegeLevel privilege;
  Timestamp created;
  Timestamp updated;
  Timestamp deleted;
  bool active;
  std::string shardId;
  UserAttributes attributes;
  Accounting accounting;

  struct __isset {
    __isset() : id(false), username(false), email(false), name(false), timezone(false), privilege(false), created(false), updated(false), deleted(false), active(false), shardId(false), attributes(false), accounting(false) {}
    bool id;
    bool username;
    bool email;
    bool name;
    bool timezone;
    bool privilege;
    bool created;
    bool updated;
    bool deleted;
    bool active;
    bool shardId;
    bool attributes;
    bool accounting;
  } __isset;

  bool operator == (const User & rhs) const
  {
    if (__isset.id != rhs.__isset.id)
      return false;
    else if (__isset.id && !(id == rhs.id))
      return false;
    if (__isset.username != rhs.__isset.username)
      return false;
    else if (__isset.username && !(username == rhs.username))
      return false;
    if (__isset.email != rhs.__isset.email)
      return false;
    else if (__isset.email && !(email == rhs.email))
      return false;
    if (__isset.name != rhs.__isset.name)
      return false;
    else if (__isset.name && !(name == rhs.name))
      return false;
    if (__isset.timezone != rhs.__isset.timezone)
      return false;
    else if (__isset.timezone && !(timezone == rhs.timezone))
      return false;
    if (__isset.privilege != rhs.__isset.privilege)
      return false;
    else if (__isset.privilege && !(privilege == rhs.privilege))
      return false;
    if (__isset.created != rhs.__isset.created)
      return false;
    else if (__isset.created && !(created == rhs.created))
      return false;
    if (__isset.updated != rhs.__isset.updated)
      return false;
    else if (__isset.updated && !(updated == rhs.updated))
      return false;
    if (__isset.deleted != rhs.__isset.deleted)
      return false;
    else if (__isset.deleted && !(deleted == rhs.deleted))
      return false;
    if (__isset.active != rhs.__isset.active)
      return false;
    else if (__isset.active && !(active == rhs.active))
      return false;
    if (__isset.shardId != rhs.__isset.shardId)
      return false;
    else if (__isset.shardId && !(shardId == rhs.shardId))
      return false;
    if (__isset.attributes != rhs.__isset.attributes)
      return false;
    else if (__isset.attributes && !(attributes == rhs.attributes))
      return false;
    if (__isset.accounting != rhs.__isset.accounting)
      return false;
    else if (__isset.accounting && !(accounting == rhs.accounting))
      return false;
    return true;
  }
  bool operator != (const User &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const User & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class Tag {
 public:

  static const char* ascii_fingerprint; // = "2E5BF02AE592E16964727D77D7FFB2D2";
  static const uint8_t binary_fingerprint[16]; // = {0x2E,0x5B,0xF0,0x2A,0xE5,0x92,0xE1,0x69,0x64,0x72,0x7D,0x77,0xD7,0xFF,0xB2,0xD2};

  Tag() : guid(""), name(""), parentGuid(""), updateSequenceNum(0) {
  }

  virtual ~Tag() throw() {}

  Guid guid;
  std::string name;
  Guid parentGuid;
  int32_t updateSequenceNum;

  struct __isset {
    __isset() : guid(false), name(false), parentGuid(false), updateSequenceNum(false) {}
    bool guid;
    bool name;
    bool parentGuid;
    bool updateSequenceNum;
  } __isset;

  bool operator == (const Tag & rhs) const
  {
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.name != rhs.__isset.name)
      return false;
    else if (__isset.name && !(name == rhs.name))
      return false;
    if (__isset.parentGuid != rhs.__isset.parentGuid)
      return false;
    else if (__isset.parentGuid && !(parentGuid == rhs.parentGuid))
      return false;
    if (__isset.updateSequenceNum != rhs.__isset.updateSequenceNum)
      return false;
    else if (__isset.updateSequenceNum && !(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    return true;
  }
  bool operator != (const Tag &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Tag & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class ResourceAttributes {
 public:

  static const char* ascii_fingerprint; // = "161DB66A1D1B8ABA25C8FC34E7518720";
  static const uint8_t binary_fingerprint[16]; // = {0x16,0x1D,0xB6,0x6A,0x1D,0x1B,0x8A,0xBA,0x25,0xC8,0xFC,0x34,0xE7,0x51,0x87,0x20};

  ResourceAttributes() : sourceURL(""), timestamp(0), latitude(0), longitude(0), altitude(0), cameraMake(""), cameraModel(""), clientWillIndex(0), recoType(""), fileName(""), attachment(0) {
  }

  virtual ~ResourceAttributes() throw() {}

  std::string sourceURL;
  Timestamp timestamp;
  double latitude;
  double longitude;
  double altitude;
  std::string cameraMake;
  std::string cameraModel;
  bool clientWillIndex;
  std::string recoType;
  std::string fileName;
  bool attachment;

  struct __isset {
    __isset() : sourceURL(false), timestamp(false), latitude(false), longitude(false), altitude(false), cameraMake(false), cameraModel(false), clientWillIndex(false), recoType(false), fileName(false), attachment(false) {}
    bool sourceURL;
    bool timestamp;
    bool latitude;
    bool longitude;
    bool altitude;
    bool cameraMake;
    bool cameraModel;
    bool clientWillIndex;
    bool recoType;
    bool fileName;
    bool attachment;
  } __isset;

  bool operator == (const ResourceAttributes & rhs) const
  {
    if (__isset.sourceURL != rhs.__isset.sourceURL)
      return false;
    else if (__isset.sourceURL && !(sourceURL == rhs.sourceURL))
      return false;
    if (__isset.timestamp != rhs.__isset.timestamp)
      return false;
    else if (__isset.timestamp && !(timestamp == rhs.timestamp))
      return false;
    if (__isset.latitude != rhs.__isset.latitude)
      return false;
    else if (__isset.latitude && !(latitude == rhs.latitude))
      return false;
    if (__isset.longitude != rhs.__isset.longitude)
      return false;
    else if (__isset.longitude && !(longitude == rhs.longitude))
      return false;
    if (__isset.altitude != rhs.__isset.altitude)
      return false;
    else if (__isset.altitude && !(altitude == rhs.altitude))
      return false;
    if (__isset.cameraMake != rhs.__isset.cameraMake)
      return false;
    else if (__isset.cameraMake && !(cameraMake == rhs.cameraMake))
      return false;
    if (__isset.cameraModel != rhs.__isset.cameraModel)
      return false;
    else if (__isset.cameraModel && !(cameraModel == rhs.cameraModel))
      return false;
    if (__isset.clientWillIndex != rhs.__isset.clientWillIndex)
      return false;
    else if (__isset.clientWillIndex && !(clientWillIndex == rhs.clientWillIndex))
      return false;
    if (__isset.recoType != rhs.__isset.recoType)
      return false;
    else if (__isset.recoType && !(recoType == rhs.recoType))
      return false;
    if (__isset.fileName != rhs.__isset.fileName)
      return false;
    else if (__isset.fileName && !(fileName == rhs.fileName))
      return false;
    if (__isset.attachment != rhs.__isset.attachment)
      return false;
    else if (__isset.attachment && !(attachment == rhs.attachment))
      return false;
    return true;
  }
  bool operator != (const ResourceAttributes &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ResourceAttributes & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class Resource {
 public:

  static const char* ascii_fingerprint; // = "C6EFB14964F3DEF6311C312F0FEE420A";
  static const uint8_t binary_fingerprint[16]; // = {0xC6,0xEF,0xB1,0x49,0x64,0xF3,0xDE,0xF6,0x31,0x1C,0x31,0x2F,0x0F,0xEE,0x42,0x0A};

  Resource() : guid(""), noteGuid(""), mime(""), width(0), height(0), duration(0), active(0), updateSequenceNum(0) {
  }

  virtual ~Resource() throw() {}

  Guid guid;
  Guid noteGuid;
  Data data;
  std::string mime;
  int16_t width;
  int16_t height;
  int16_t duration;
  bool active;
  Data recognition;
  ResourceAttributes attributes;
  int32_t updateSequenceNum;
  Data alternateData;

  struct __isset {
    __isset() : guid(false), noteGuid(false), data(false), mime(false), width(false), height(false), duration(false), active(false), recognition(false), attributes(false), updateSequenceNum(false), alternateData(false) {}
    bool guid;
    bool noteGuid;
    bool data;
    bool mime;
    bool width;
    bool height;
    bool duration;
    bool active;
    bool recognition;
    bool attributes;
    bool updateSequenceNum;
    bool alternateData;
  } __isset;

  bool operator == (const Resource & rhs) const
  {
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.noteGuid != rhs.__isset.noteGuid)
      return false;
    else if (__isset.noteGuid && !(noteGuid == rhs.noteGuid))
      return false;
    if (__isset.data != rhs.__isset.data)
      return false;
    else if (__isset.data && !(data == rhs.data))
      return false;
    if (__isset.mime != rhs.__isset.mime)
      return false;
    else if (__isset.mime && !(mime == rhs.mime))
      return false;
    if (__isset.width != rhs.__isset.width)
      return false;
    else if (__isset.width && !(width == rhs.width))
      return false;
    if (__isset.height != rhs.__isset.height)
      return false;
    else if (__isset.height && !(height == rhs.height))
      return false;
    if (__isset.duration != rhs.__isset.duration)
      return false;
    else if (__isset.duration && !(duration == rhs.duration))
      return false;
    if (__isset.active != rhs.__isset.active)
      return false;
    else if (__isset.active && !(active == rhs.active))
      return false;
    if (__isset.recognition != rhs.__isset.recognition)
      return false;
    else if (__isset.recognition && !(recognition == rhs.recognition))
      return false;
    if (__isset.attributes != rhs.__isset.attributes)
      return false;
    else if (__isset.attributes && !(attributes == rhs.attributes))
      return false;
    if (__isset.updateSequenceNum != rhs.__isset.updateSequenceNum)
      return false;
    else if (__isset.updateSequenceNum && !(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    if (__isset.alternateData != rhs.__isset.alternateData)
      return false;
    else if (__isset.alternateData && !(alternateData == rhs.alternateData))
      return false;
    return true;
  }
  bool operator != (const Resource &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Resource & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteAttributes {
 public:

  static const char* ascii_fingerprint; // = "FCEACAC5E6423F30EC4ECA84F833084F";
  static const uint8_t binary_fingerprint[16]; // = {0xFC,0xEA,0xCA,0xC5,0xE6,0x42,0x3F,0x30,0xEC,0x4E,0xCA,0x84,0xF8,0x33,0x08,0x4F};

  NoteAttributes() : subjectDate(0), latitude(0), longitude(0), altitude(0), author(""), source(""), sourceURL(""), sourceApplication("") {
  }

  virtual ~NoteAttributes() throw() {}

  Timestamp subjectDate;
  double latitude;
  double longitude;
  double altitude;
  std::string author;
  std::string source;
  std::string sourceURL;
  std::string sourceApplication;

  struct __isset {
    __isset() : subjectDate(false), latitude(false), longitude(false), altitude(false), author(false), source(false), sourceURL(false), sourceApplication(false) {}
    bool subjectDate;
    bool latitude;
    bool longitude;
    bool altitude;
    bool author;
    bool source;
    bool sourceURL;
    bool sourceApplication;
  } __isset;

  bool operator == (const NoteAttributes & rhs) const
  {
    if (__isset.subjectDate != rhs.__isset.subjectDate)
      return false;
    else if (__isset.subjectDate && !(subjectDate == rhs.subjectDate))
      return false;
    if (__isset.latitude != rhs.__isset.latitude)
      return false;
    else if (__isset.latitude && !(latitude == rhs.latitude))
      return false;
    if (__isset.longitude != rhs.__isset.longitude)
      return false;
    else if (__isset.longitude && !(longitude == rhs.longitude))
      return false;
    if (__isset.altitude != rhs.__isset.altitude)
      return false;
    else if (__isset.altitude && !(altitude == rhs.altitude))
      return false;
    if (__isset.author != rhs.__isset.author)
      return false;
    else if (__isset.author && !(author == rhs.author))
      return false;
    if (__isset.source != rhs.__isset.source)
      return false;
    else if (__isset.source && !(source == rhs.source))
      return false;
    if (__isset.sourceURL != rhs.__isset.sourceURL)
      return false;
    else if (__isset.sourceURL && !(sourceURL == rhs.sourceURL))
      return false;
    if (__isset.sourceApplication != rhs.__isset.sourceApplication)
      return false;
    else if (__isset.sourceApplication && !(sourceApplication == rhs.sourceApplication))
      return false;
    return true;
  }
  bool operator != (const NoteAttributes &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteAttributes & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class Note {
 public:

  static const char* ascii_fingerprint; // = "4436B6046C67840B3AE90406ACF39CA3";
  static const uint8_t binary_fingerprint[16]; // = {0x44,0x36,0xB6,0x04,0x6C,0x67,0x84,0x0B,0x3A,0xE9,0x04,0x06,0xAC,0xF3,0x9C,0xA3};

  Note() : guid(""), title(""), content(""), contentHash(""), contentLength(0), created(0), updated(0), deleted(0), active(0), updateSequenceNum(0), notebookGuid("") {
  }

  virtual ~Note() throw() {}

  Guid guid;
  std::string title;
  std::string content;
  std::string contentHash;
  int32_t contentLength;
  Timestamp created;
  Timestamp updated;
  Timestamp deleted;
  bool active;
  int32_t updateSequenceNum;
  std::string notebookGuid;
  std::vector<Guid>  tagGuids;
  std::vector<Resource>  resources;
  NoteAttributes attributes;
  std::vector<std::string>  tagNames;

  struct __isset {
    __isset() : guid(false), title(false), content(false), contentHash(false), contentLength(false), created(false), updated(false), deleted(false), active(false), updateSequenceNum(false), notebookGuid(false), tagGuids(false), resources(false), attributes(false), tagNames(false) {}
    bool guid;
    bool title;
    bool content;
    bool contentHash;
    bool contentLength;
    bool created;
    bool updated;
    bool deleted;
    bool active;
    bool updateSequenceNum;
    bool notebookGuid;
    bool tagGuids;
    bool resources;
    bool attributes;
    bool tagNames;
  } __isset;

  bool operator == (const Note & rhs) const
  {
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.title != rhs.__isset.title)
      return false;
    else if (__isset.title && !(title == rhs.title))
      return false;
    if (__isset.content != rhs.__isset.content)
      return false;
    else if (__isset.content && !(content == rhs.content))
      return false;
    if (__isset.contentHash != rhs.__isset.contentHash)
      return false;
    else if (__isset.contentHash && !(contentHash == rhs.contentHash))
      return false;
    if (__isset.contentLength != rhs.__isset.contentLength)
      return false;
    else if (__isset.contentLength && !(contentLength == rhs.contentLength))
      return false;
    if (__isset.created != rhs.__isset.created)
      return false;
    else if (__isset.created && !(created == rhs.created))
      return false;
    if (__isset.updated != rhs.__isset.updated)
      return false;
    else if (__isset.updated && !(updated == rhs.updated))
      return false;
    if (__isset.deleted != rhs.__isset.deleted)
      return false;
    else if (__isset.deleted && !(deleted == rhs.deleted))
      return false;
    if (__isset.active != rhs.__isset.active)
      return false;
    else if (__isset.active && !(active == rhs.active))
      return false;
    if (__isset.updateSequenceNum != rhs.__isset.updateSequenceNum)
      return false;
    else if (__isset.updateSequenceNum && !(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    if (__isset.notebookGuid != rhs.__isset.notebookGuid)
      return false;
    else if (__isset.notebookGuid && !(notebookGuid == rhs.notebookGuid))
      return false;
    if (__isset.tagGuids != rhs.__isset.tagGuids)
      return false;
    else if (__isset.tagGuids && !(tagGuids == rhs.tagGuids))
      return false;
    if (__isset.resources != rhs.__isset.resources)
      return false;
    else if (__isset.resources && !(resources == rhs.resources))
      return false;
    if (__isset.attributes != rhs.__isset.attributes)
      return false;
    else if (__isset.attributes && !(attributes == rhs.attributes))
      return false;
    if (__isset.tagNames != rhs.__isset.tagNames)
      return false;
    else if (__isset.tagNames && !(tagNames == rhs.tagNames))
      return false;
    return true;
  }
  bool operator != (const Note &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Note & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class Publishing {
 public:

  static const char* ascii_fingerprint; // = "A62655866CF21A0C0C20242173A3567A";
  static const uint8_t binary_fingerprint[16]; // = {0xA6,0x26,0x55,0x86,0x6C,0xF2,0x1A,0x0C,0x0C,0x20,0x24,0x21,0x73,0xA3,0x56,0x7A};

  Publishing() : uri(""), ascending(0), publicDescription("") {
  }

  virtual ~Publishing() throw() {}

  std::string uri;
  NoteSortOrder order;
  bool ascending;
  std::string publicDescription;

  struct __isset {
    __isset() : uri(false), order(false), ascending(false), publicDescription(false) {}
    bool uri;
    bool order;
    bool ascending;
    bool publicDescription;
  } __isset;

  bool operator == (const Publishing & rhs) const
  {
    if (__isset.uri != rhs.__isset.uri)
      return false;
    else if (__isset.uri && !(uri == rhs.uri))
      return false;
    if (__isset.order != rhs.__isset.order)
      return false;
    else if (__isset.order && !(order == rhs.order))
      return false;
    if (__isset.ascending != rhs.__isset.ascending)
      return false;
    else if (__isset.ascending && !(ascending == rhs.ascending))
      return false;
    if (__isset.publicDescription != rhs.__isset.publicDescription)
      return false;
    else if (__isset.publicDescription && !(publicDescription == rhs.publicDescription))
      return false;
    return true;
  }
  bool operator != (const Publishing &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Publishing & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class Notebook {
 public:

  static const char* ascii_fingerprint; // = "229D750AF1F671E43C0C284E74A2DFB1";
  static const uint8_t binary_fingerprint[16]; // = {0x22,0x9D,0x75,0x0A,0xF1,0xF6,0x71,0xE4,0x3C,0x0C,0x28,0x4E,0x74,0xA2,0xDF,0xB1};

  Notebook() : guid(""), name(""), updateSequenceNum(0), defaultNotebook(0), serviceCreated(0), serviceUpdated(0), published(0) {
  }

  virtual ~Notebook() throw() {}

  Guid guid;
  std::string name;
  int32_t updateSequenceNum;
  bool defaultNotebook;
  Timestamp serviceCreated;
  Timestamp serviceUpdated;
  Publishing publishing;
  bool published;

  struct __isset {
    __isset() : guid(false), name(false), updateSequenceNum(false), defaultNotebook(false), serviceCreated(false), serviceUpdated(false), publishing(false), published(false) {}
    bool guid;
    bool name;
    bool updateSequenceNum;
    bool defaultNotebook;
    bool serviceCreated;
    bool serviceUpdated;
    bool publishing;
    bool published;
  } __isset;

  bool operator == (const Notebook & rhs) const
  {
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.name != rhs.__isset.name)
      return false;
    else if (__isset.name && !(name == rhs.name))
      return false;
    if (__isset.updateSequenceNum != rhs.__isset.updateSequenceNum)
      return false;
    else if (__isset.updateSequenceNum && !(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    if (__isset.defaultNotebook != rhs.__isset.defaultNotebook)
      return false;
    else if (__isset.defaultNotebook && !(defaultNotebook == rhs.defaultNotebook))
      return false;
    if (__isset.serviceCreated != rhs.__isset.serviceCreated)
      return false;
    else if (__isset.serviceCreated && !(serviceCreated == rhs.serviceCreated))
      return false;
    if (__isset.serviceUpdated != rhs.__isset.serviceUpdated)
      return false;
    else if (__isset.serviceUpdated && !(serviceUpdated == rhs.serviceUpdated))
      return false;
    if (__isset.publishing != rhs.__isset.publishing)
      return false;
    else if (__isset.publishing && !(publishing == rhs.publishing))
      return false;
    if (__isset.published != rhs.__isset.published)
      return false;
    else if (__isset.published && !(published == rhs.published))
      return false;
    return true;
  }
  bool operator != (const Notebook &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Notebook & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class SavedSearch {
 public:

  static const char* ascii_fingerprint; // = "F8123D2B1DD5C24610D0B2386CFF86D2";
  static const uint8_t binary_fingerprint[16]; // = {0xF8,0x12,0x3D,0x2B,0x1D,0xD5,0xC2,0x46,0x10,0xD0,0xB2,0x38,0x6C,0xFF,0x86,0xD2};

  SavedSearch() : guid(""), name(""), query(""), updateSequenceNum(0) {
  }

  virtual ~SavedSearch() throw() {}

  Guid guid;
  std::string name;
  std::string query;
  QueryFormat format;
  int32_t updateSequenceNum;

  struct __isset {
    __isset() : guid(false), name(false), query(false), format(false), updateSequenceNum(false) {}
    bool guid;
    bool name;
    bool query;
    bool format;
    bool updateSequenceNum;
  } __isset;

  bool operator == (const SavedSearch & rhs) const
  {
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.name != rhs.__isset.name)
      return false;
    else if (__isset.name && !(name == rhs.name))
      return false;
    if (__isset.query != rhs.__isset.query)
      return false;
    else if (__isset.query && !(query == rhs.query))
      return false;
    if (__isset.format != rhs.__isset.format)
      return false;
    else if (__isset.format && !(format == rhs.format))
      return false;
    if (__isset.updateSequenceNum != rhs.__isset.updateSequenceNum)
      return false;
    else if (__isset.updateSequenceNum && !(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    return true;
  }
  bool operator != (const SavedSearch &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const SavedSearch & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class Ad {
 public:

  static const char* ascii_fingerprint; // = "1D44D2C6F1EFFA11DD31E8A7F4063DD3";
  static const uint8_t binary_fingerprint[16]; // = {0x1D,0x44,0xD2,0xC6,0xF1,0xEF,0xFA,0x11,0xDD,0x31,0xE8,0xA7,0xF4,0x06,0x3D,0xD3};

  Ad() : id(0), width(0), height(0), advertiserName(""), imageUrl(""), destinationUrl(""), displaySeconds(0), score(0), image(""), imageMime(""), html(""), displayFrequency(0) {
  }

  virtual ~Ad() throw() {}

  int32_t id;
  int16_t width;
  int16_t height;
  std::string advertiserName;
  std::string imageUrl;
  std::string destinationUrl;
  int16_t displaySeconds;
  double score;
  std::string image;
  std::string imageMime;
  std::string html;
  double displayFrequency;

  struct __isset {
    __isset() : id(false), width(false), height(false), advertiserName(false), imageUrl(false), destinationUrl(false), displaySeconds(false), score(false), image(false), imageMime(false), html(false), displayFrequency(false) {}
    bool id;
    bool width;
    bool height;
    bool advertiserName;
    bool imageUrl;
    bool destinationUrl;
    bool displaySeconds;
    bool score;
    bool image;
    bool imageMime;
    bool html;
    bool displayFrequency;
  } __isset;

  bool operator == (const Ad & rhs) const
  {
    if (__isset.id != rhs.__isset.id)
      return false;
    else if (__isset.id && !(id == rhs.id))
      return false;
    if (__isset.width != rhs.__isset.width)
      return false;
    else if (__isset.width && !(width == rhs.width))
      return false;
    if (__isset.height != rhs.__isset.height)
      return false;
    else if (__isset.height && !(height == rhs.height))
      return false;
    if (__isset.advertiserName != rhs.__isset.advertiserName)
      return false;
    else if (__isset.advertiserName && !(advertiserName == rhs.advertiserName))
      return false;
    if (__isset.imageUrl != rhs.__isset.imageUrl)
      return false;
    else if (__isset.imageUrl && !(imageUrl == rhs.imageUrl))
      return false;
    if (__isset.destinationUrl != rhs.__isset.destinationUrl)
      return false;
    else if (__isset.destinationUrl && !(destinationUrl == rhs.destinationUrl))
      return false;
    if (__isset.displaySeconds != rhs.__isset.displaySeconds)
      return false;
    else if (__isset.displaySeconds && !(displaySeconds == rhs.displaySeconds))
      return false;
    if (__isset.score != rhs.__isset.score)
      return false;
    else if (__isset.score && !(score == rhs.score))
      return false;
    if (__isset.image != rhs.__isset.image)
      return false;
    else if (__isset.image && !(image == rhs.image))
      return false;
    if (__isset.imageMime != rhs.__isset.imageMime)
      return false;
    else if (__isset.imageMime && !(imageMime == rhs.imageMime))
      return false;
    if (__isset.html != rhs.__isset.html)
      return false;
    else if (__isset.html && !(html == rhs.html))
      return false;
    if (__isset.displayFrequency != rhs.__isset.displayFrequency)
      return false;
    else if (__isset.displayFrequency && !(displayFrequency == rhs.displayFrequency))
      return false;
    return true;
  }
  bool operator != (const Ad &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Ad & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class SharedNotebook {
 public:

  static const char* ascii_fingerprint; // = "3ECBE8380CBD03A6168589256068F022";
  static const uint8_t binary_fingerprint[16]; // = {0x3E,0xCB,0xE8,0x38,0x0C,0xBD,0x03,0xA6,0x16,0x85,0x89,0x25,0x60,0x68,0xF0,0x22};

  SharedNotebook() : id(0), userId(0), notebookGuid(""), email(""), notebookModifiable(0), requireLogin(0), serviceCreated(0), shareKey(""), username("") {
  }

  virtual ~SharedNotebook() throw() {}

  int64_t id;
  int32_t userId;
  std::string notebookGuid;
  std::string email;
  bool notebookModifiable;
  bool requireLogin;
  Timestamp serviceCreated;
  std::string shareKey;
  std::string username;

  struct __isset {
    __isset() : id(false), userId(false), notebookGuid(false), email(false), notebookModifiable(false), requireLogin(false), serviceCreated(false), shareKey(false), username(false) {}
    bool id;
    bool userId;
    bool notebookGuid;
    bool email;
    bool notebookModifiable;
    bool requireLogin;
    bool serviceCreated;
    bool shareKey;
    bool username;
  } __isset;

  bool operator == (const SharedNotebook & rhs) const
  {
    if (__isset.id != rhs.__isset.id)
      return false;
    else if (__isset.id && !(id == rhs.id))
      return false;
    if (__isset.userId != rhs.__isset.userId)
      return false;
    else if (__isset.userId && !(userId == rhs.userId))
      return false;
    if (__isset.notebookGuid != rhs.__isset.notebookGuid)
      return false;
    else if (__isset.notebookGuid && !(notebookGuid == rhs.notebookGuid))
      return false;
    if (__isset.email != rhs.__isset.email)
      return false;
    else if (__isset.email && !(email == rhs.email))
      return false;
    if (__isset.notebookModifiable != rhs.__isset.notebookModifiable)
      return false;
    else if (__isset.notebookModifiable && !(notebookModifiable == rhs.notebookModifiable))
      return false;
    if (__isset.requireLogin != rhs.__isset.requireLogin)
      return false;
    else if (__isset.requireLogin && !(requireLogin == rhs.requireLogin))
      return false;
    if (__isset.serviceCreated != rhs.__isset.serviceCreated)
      return false;
    else if (__isset.serviceCreated && !(serviceCreated == rhs.serviceCreated))
      return false;
    if (__isset.shareKey != rhs.__isset.shareKey)
      return false;
    else if (__isset.shareKey && !(shareKey == rhs.shareKey))
      return false;
    if (__isset.username != rhs.__isset.username)
      return false;
    else if (__isset.username && !(username == rhs.username))
      return false;
    return true;
  }
  bool operator != (const SharedNotebook &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const SharedNotebook & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

class LinkedNotebook {
 public:

  static const char* ascii_fingerprint; // = "266757B9EEA2E1AC09A9BA90AB46F4D7";
  static const uint8_t binary_fingerprint[16]; // = {0x26,0x67,0x57,0xB9,0xEE,0xA2,0xE1,0xAC,0x09,0xA9,0xBA,0x90,0xAB,0x46,0xF4,0xD7};

  LinkedNotebook() : id(0), shareName(""), username(""), shardId(""), shareKey(""), uri("") {
  }

  virtual ~LinkedNotebook() throw() {}

  int64_t id;
  std::string shareName;
  std::string username;
  std::string shardId;
  std::string shareKey;
  std::string uri;

  struct __isset {
    __isset() : id(false), shareName(false), username(false), shardId(false), shareKey(false), uri(false) {}
    bool id;
    bool shareName;
    bool username;
    bool shardId;
    bool shareKey;
    bool uri;
  } __isset;

  bool operator == (const LinkedNotebook & rhs) const
  {
    if (__isset.id != rhs.__isset.id)
      return false;
    else if (__isset.id && !(id == rhs.id))
      return false;
    if (__isset.shareName != rhs.__isset.shareName)
      return false;
    else if (__isset.shareName && !(shareName == rhs.shareName))
      return false;
    if (__isset.username != rhs.__isset.username)
      return false;
    else if (__isset.username && !(username == rhs.username))
      return false;
    if (__isset.shardId != rhs.__isset.shardId)
      return false;
    else if (__isset.shardId && !(shardId == rhs.shardId))
      return false;
    if (__isset.shareKey != rhs.__isset.shareKey)
      return false;
    else if (__isset.shareKey && !(shareKey == rhs.shareKey))
      return false;
    if (__isset.uri != rhs.__isset.uri)
      return false;
    else if (__isset.uri && !(uri == rhs.uri))
      return false;
    return true;
  }
  bool operator != (const LinkedNotebook &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const LinkedNotebook & ) const;

  uint32_t read(apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(apache::thrift::protocol::TProtocol* oprot) const;

};

}} // namespace

#endif
