/*
 * This file is part of CityGuide
 *
 * Copyright (C) 2007 Pekka Rönkkö (pronkko@gmail.com).
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
#ifndef _PARSER_H
#define _PARSER_H

#include <glib.h>

typedef struct _Coordinates Coordinates;

struct _Coordinates {
    gdouble lat;
    gdouble lng;
};

typedef struct _PlacesInfo PlacesInfo;

struct _PlacesInfo {
    gchar *lat;
    gchar *lng;
    gchar *name;
    gboolean show_name;
    gchar *icon;
    gchar *text;
    guint min_zoomlevel;
    guint max_zoomlevel;
};


gchar *parse_place(Coordinates coords);
GPtrArray *parse_wikipedia_articles(Coordinates coords);
GPtrArray *parse_populated_places(Coordinates coords);
gdouble calculate_distance(gdouble lat1, gdouble lon1, gdouble lat2,
			   gdouble lon2);

#endif



