/*
 * This file is part of CityGuide
 *
 * Copyright (C) 2007 Pekka Rönkkö (pronkko@gmail.com).
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
#ifndef _APPDATA_H
#define _APPDATA_H

#include <glib.h>
#include "parser.h"

typedef struct _AppData AppData;

struct _AppData {
    HildonProgram *program;
    GtkWidget *window;
    osso_context_t *osso_context;
    GtkWidget *vbox_places;
    GtkWidget *table_POI;
    GtkWidget *coords_label;
};

#define DEBUG_LEVEL 0

#define DEBUG_FUNC_START \
	if (DEBUG_LEVEL) g_printf(" >> %s starts\n", __func__); fflush(stdout);


#define DEBUG_FUNC_END \
	if (DEBUG_LEVEL) g_printf(" << %s ends\n", __func__); fflush(stdout);



#define CURRENT_PLACE_IMAGE "/usr/share/cityguide/pictures/background_location.png"
#define ZOOM_OUT_IMAGE "/usr/share/cityguide/pictures/icon_zoom_out_26.png"
#define ZOOM_IN_IMAGE  "/usr/share/cityguide/pictures/icon_zoom_in_26.png"
#define COORDS_IMAGE "/usr/share/cityguide/pictures/background_coordinates.png"
#define AUTO_CENTER_ON "/usr/share/cityguide/pictures/icon_autocenter_on_26.png"
#define AUTO_CENTER_OFF "/usr/share/cityguide/pictures/icon_autocenter_off_26.png"


#define BACKGROUND_PANEL "/usr/share/cityguide/pictures/background_pane.png"
















#endif
