/*
 * garchivereadercommandline.h - routines to manipulate archive files
 * using command line programs.
 *
 * Copyright (C) 2008 Benoit Goudreault-Emond (bgoudreaultemond@gmail.com).
 * Inspired by code from John Coppens (john@jcoppens.com).
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __G_ARCHIVE_READER_COMMAND_LINE_H__
#define __G_ARCHIVE_READER_COMMAND_LINE_H__

#include <gdk/gdk.h>
#include <glib-object.h>
#include "garchivereader.h"

G_BEGIN_DECLS

#define G_TYPE_ARCHIVE_READER_COMMAND_LINE            (g_archive_reader_command_line_get_type())
#define G_ARCHIVE_READER_COMMAND_LINE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), G_TYPE_ARCHIVE_READER_COMMAND_LINE, GArchiveReaderCommandLine))
#define G_ARCHIVE_READER_COMMAND_LINE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_ARCHIVE_READER_COMMAND_LINE, GArchiveReaderCommandLineClass))
#define G_IS_ARCHIVE_READER_COMMAND_LINE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), G_TYPE_ARCHIVE_READER_COMMAND_LINE))
#define G_IS_ARCHIVE_READER_COMMAND_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_ARCHIVE_READER_COMMAND_LINE))
#define G_ARCHIVE_READER_COMMAND_LINE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), G_TYPE_ARCHIVE_READER_COMMAND_LINE, GArchiveReaderCommandLineClass))

typedef struct _GArchiveReaderCommandLine GArchiveReaderCommandLine;
typedef struct _GArchiveReaderCommandLineClass GArchiveReaderCommandLineClass;

struct _GArchiveReaderCommandLine
{
    GObject    parent;
    gchar**    list_command;
    int        list_command_archive_index;
    gchar**    decompress_command;
    int        decompress_command_archive_index;
    int        decompress_command_file_index;
    gboolean   decompress_command_file_needs_escape;
    guchar*    buf;
    guint      buf_size;

    magic_sign magic;

    gchar*     current_filename;
    gchar*     last_error;
    GArray*    page_list;
    SortStrategy strategy;
};

struct _GArchiveReaderCommandLineClass
{
    GObjectClass parent;
};

GType           g_archive_reader_command_line_get_type(void) G_GNUC_CONST;

GArchiveReader* g_archive_reader_command_line_new(guchar* buf,
						  int buf_size,
						  magic_sign magic,
						  gchar** list_command,
						  gchar** decompress_command);

G_END_DECLS
#endif
