/*
 * garchivereader.c - routines to abstract archive reading logic
 *
 * Copyright (C) 2008 Benoit Goudreault-Emond (bgoudreaultemond@gmail.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <string.h>

#include "garchivereader.h"

static void
g_archive_reader_base_init(gpointer g_class)
{
    static gboolean initialized = FALSE;
    if(!initialized)
	initialized = TRUE;
}

GType
g_archive_reader_get_type(void)
{
    static GType type = 0;
    if(type)
	return type;
    static const GTypeInfo info = {
	sizeof(GArchiveReaderClass),
	g_archive_reader_base_init,
	NULL,
	NULL,
	NULL,
	NULL,
	0,
	0,
	NULL
    };
    type = g_type_register_static(G_TYPE_INTERFACE,
				  "GArchiveReader",
				  &info,
				  0);
    return type;
}

/* methods */
int    
g_archive_reader_register_path(GArchiveReader* reader,
			       const gchar* path)
{
    return G_ARCHIVE_READER_GET_CLASS(reader)->register_path(reader, path);
}

GArray*      
g_archive_reader_get_file_list(GArchiveReader* reader)
{
    return G_ARCHIVE_READER_GET_CLASS(reader)->get_file_list(reader);
}

GdkPixbuf*  
g_archive_reader_get_page     (GArchiveReader* reader,
			       int page_number,
			       gdouble* w,
			       gdouble* h)
{
    return G_ARCHIVE_READER_GET_CLASS(reader)->get_page(reader,
							page_number,
							w,
							h);
}

gchar*
g_archive_reader_get_last_error(GArchiveReader* reader)
{
    return G_ARCHIVE_READER_GET_CLASS(reader)->get_last_error(reader);
}

int
g_archive_reader_check_magic  (const gchar* path,
			       const magic_sign* magic)
{
    FILE* f;
    char sign[20];
    int retval = 0;

    if(!(f = fopen(path, "rb")))
    {
	return -1;
    }

    if(!fseek(f, magic->offs, SEEK_SET) &&
       fread(sign, 1, magic->len, f) == magic->len)
    {
	/* If the read went well, we need to compare the characters */
	/* strstr works here, but only if no \0's are in the string */
	/* and if we first terminate the string read too */
	sign[magic->len] = '\0';
	if(!strcmp(sign, magic->sign))
	{
	    fclose(f);
	    return 1;
	}
    }
    fclose(f);
    return 0;
}
