/*
 *  conf.h - configuration
 *
 *  Copyright (C) 1997-2004 John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <gtk/gtk.h>

#define	prog_name	"cbrPager"
#define prog_version	"0.9.24"

#define FOLLOW_TIMER	150

enum {NAV_NW, NAV_NE, NAV_SE, NAV_SW};
enum {DIRM_LAST, DIRM_FIXED};

enum {	ACC_FUNCTION,
	ACC_MODS,
	ACC_ACCEL,
	ACC_DISABLE,
	ACC_ESCAPE,
	ACC_COLS
};


typedef struct {
  // Preferences that are saved
  char	lastbook[200],
	fixeddir[200],
	nav_hidden;		// Non-zero to hide navbar
  int	nextpage,		// Next page 'mode'
	prevpage,		// Previous page 'mode'
        nrpages,		// Number of visible pages (1 or 2)
	initwidth,		// Initial window width
	initheight,		// Initial window height
	nav_pos,		// Horizontal navigator position
	nav_hor,		// Vertical navigator position
	dirmode,		// Remembered or fixed directory
        manga_mode,             // Whether we're in manga mode for 2-page reading
        auto_rotate,            // Whether we're in auto rotate mode
        pagenumber,             /* Last page number used */
        zone_size,		/* Size of scroll zone, in pels */
        buffer_size,            /* Image buffer size, in KB */
        scrollbars_fullscreen,  /* Whether to show scrollbars when fullscreen */
        rotate_ccw;		/* Whether rotation is counter-clockwise (default clockwise) */
	
  // Preferences that are not remembered
  char  explicit_file;
  
} preferences;

extern preferences pref;
extern double	   zoom_factor;
extern int	   debug;

void		save_config(void);
void		load_config(void);
void		show_config(GtkWidget *ref);
void		parse_config(GtkWidget *ref);

void		conf_accel_tview_cursor_changed(void);
void		conf_accel_tview_realize(GtkTreeView *tview, gboolean main_keys);
const char*     find_accelerator(int keyval, int state);
gboolean        toggle_accelerator_mode(void);
