/*
 * garchivereaderunzip.h - routines to manipulate ZIP archive files
 *
 * Copyright (C) 2008 Benoit Goudreault-Emond (bgoudreaultemond@gmail.com).
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __G_ARCHIVE_READER_UNZIP_H__
#define __G_ARCHIVE_READER_UNZIP_H__

#include <gdk/gdk.h>
#include <glib-object.h>
#include "unzip.h"
#include "garchivereader.h"

G_BEGIN_DECLS

#define G_TYPE_ARCHIVE_READER_UNZIP            (g_archive_reader_unzip_get_type())
#define G_ARCHIVE_READER_UNZIP(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), G_TYPE_ARCHIVE_READER_UNZIP, GArchiveReaderUnzip))
#define G_ARCHIVE_READER_UNZIP_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_ARCHIVE_READER_UNZIP, GArchiveReaderUnzipClass))
#define G_IS_ARCHIVE_READER_UNZIP(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), G_TYPE_ARCHIVE_READER_UNZIP))
#define G_IS_ARCHIVE_READER_UNZIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_ARCHIVE_READER_UNZIP))
#define G_ARCHIVE_READER_UNZIP_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), G_TYPE_ARCHIVE_READER+UNZIP, GArchiveReaderUnzipClass))

typedef struct _GArchiveReaderUnzip GArchiveReaderUnzip;
typedef struct _GArchiveReaderUnzipClass GArchiveReaderUnzipClass;

struct _GArchiveReaderUnzip
{
    GObject    parent;

    magic_sign magic;
    guchar*    buf;
    int        buf_size;

    unzFile    current_file;
    gchar*     last_error;
    GList*     page_list;
};

struct _GArchiveReaderUnzipClass
{
    GObjectClass parent;
};

GType           g_archive_reader_unzip_get_type(void) G_GNUC_CONST;

GArchiveReader* g_archive_reader_unzip_new(guchar* buf, int buf_size, magic_sign magic);

G_END_DECLS
#endif
