#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#if USE_HILDON
#    include "hildon/hildon-banner.h"
#    include "hildon/hildon-file-system-model.h"
#    include "hildon/hildon-file-chooser-dialog.h"
#    define CONFIG_WINDOW_NAME "config_window_maemo"
#else
#    define CONFIG_WINDOW_NAME "config_window"
#endif
#include <string.h>

#include "gtkimageview.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "conf.h"
#include "global.h"
#include "main.h"

gboolean
on_main_canvas_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  main_canvas_buttonpressed(event);
  return FALSE;
}


gboolean
on_main_canvas_button_release_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  main_canvas_buttonreleased(event);
  return FALSE;
}

gboolean
on_main_canvas_motion_event            (GtkWidget       *widget,
					GdkEventMotion  *event,
					gpointer         user_data)
{
  main_canvas_motion(event);
  return FALSE;
}


gboolean
on_main_canvas_key_press_event         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  main_canvas_keyevent(event, TRUE);
  
  return FALSE;
}

gboolean
on_main_canvas_key_release_event       (GtkWidget       *widget,
					GdkEventKey     *event,
					gpointer         user_data)
{
  main_canvas_keyevent(event, FALSE);

  return FALSE;
}

void
on_begin_btn_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  goto_begin();
}


void
on_next_btn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  next_page(0);
}


void
on_back_btn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  previous_page(0);
}


void
on_last_btn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  goto_end();
}


void
on_zoom_out_btn_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  set_zoom_factor(zoom_factor / 1.1);
}


void
on_zoom_fit_btn_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  set_zoom_fit();
}


void
on_zoom_width_btn_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  set_zoom_width();
}


void
on_zoom_in_btn_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  set_zoom_factor(zoom_factor * 1.1);
}


void
on_zoom_orig_btn_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  set_zoom_factor(1.0);
}

void
on_rotate_btn_clicked                  (GtkButton       *button,
					gpointer         user_data)
{
  rotate(TRUE);
}

void
on_fullscreen_btn_clicked              (GtkButton       *button,
					gpointer         user_data)
{
  toggle_fullscreen();
}


void
fs_ok_sel(GtkWidget *w, GtkFileSelection *fs)
{
    const gchar* fn = gtk_file_selection_get_filename(fs);
    if(strcmp(pref.lastbook, fn))
	pref.pagenumber = 0;
    
    strcpy(pref.lastbook, fn);
    gtk_widget_destroy(GTK_WIDGET(fs));
    
    save_config();
    start_show();
}


#ifdef USE_HILDON
HildonFileSystemModel* get_file_system_model(GtkWidget *ref_widget)
{
  return HILDON_FILE_SYSTEM_MODEL(g_object_new(HILDON_TYPE_FILE_SYSTEM_MODEL,
					       "ref_widget", ref_widget, NULL));
}

void
on_open_btn_clicked(GtkButton* button, gpointer user_data)
{
    GtkWidget* fs;
    HildonFileSystemModel* model = NULL;
    int has_filename = 0;
    
    if(!(model = get_file_system_model(MainWindow))) 
    {
	hildon_banner_show_information(MainWindow, NULL, _("Unable to get fs model"));
	return;
    }
    
    fs = hildon_file_chooser_dialog_new_with_properties(GTK_WINDOW(MainWindow), 
							"file_system_model", model,
							"action", GTK_FILE_CHOOSER_ACTION_OPEN,
							NULL);
    if(pref.lastbook) 
    {
	gtk_file_chooser_select_filename(GTK_FILE_CHOOSER(fs), pref.lastbook);
    }
    gtk_widget_show_all(fs);
    
    if(gtk_dialog_run(GTK_DIALOG(fs)) == GTK_RESPONSE_OK) 
    {
	const gchar* fn = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(fs));
	if(strcmp(pref.lastbook, fn))
	    pref.pagenumber = 0;
	strcpy(pref.lastbook, fn);
	has_filename = 1;
    }
    gtk_widget_destroy(fs);
    if(has_filename) 
    {
	save_config();
	start_show();
    }
}
#else
void
on_open_btn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *fs = create_fileselection1();

  gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs), pref.lastbook);

  g_signal_connect(G_OBJECT(GTK_FILE_SELECTION (fs)->ok_button),
		"clicked", G_CALLBACK(fs_ok_sel), (gpointer) fs);

  g_signal_connect_swapped (G_OBJECT 
		(GTK_FILE_SELECTION (fs)->cancel_button),
		"clicked", G_CALLBACK(gtk_widget_destroy),
		G_OBJECT (fs));

  gtk_widget_show(fs);
}
#endif

void
on_open_activate                       (GtkMenuItem     *menuitem,
					gpointer         user_data)
{
    on_open_btn_clicked(NULL, user_data);
}

void
on_quit_btn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  clean_up();
  gtk_exit(0);
}

void
on_quit_activate                       (GtkMenuItem     *menuitem,
					gpointer         user_data)
{
    on_quit_btn_clicked(NULL, user_data);
}

gboolean
on_MainWindow_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  clean_up();
  gtk_exit(0);

  return FALSE;
}


void
on_pref_btn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  char *ttl;
  
#if USE_HILDON
  w = create_config_window_maemo();
#else
  w = create_config_window();
#endif
  ttl = g_strdup_printf("%s %s v%s", _("Preferences"), prog_name,
        prog_version);
  gtk_window_set_title(GTK_WINDOW(w), ttl);
  gtk_widget_show(w);
}


void
on_conf_cancel_btn_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(lookup_widget(GTK_WIDGET(button), CONFIG_WINDOW_NAME));
}


void
on_conf_save_btn_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  int old_rotation = pref.rotate_ccw;
  parse_config(GTK_WIDGET(button));
  if(old_rotation != pref.rotate_ccw) {
    toggle_rotation_direction();
  }
  save_config();
  gtk_widget_destroy(lookup_widget(GTK_WIDGET(button), CONFIG_WINDOW_NAME));
}


void
on_config_window_realize               (GtkWidget       *widget,
                                        gpointer         user_data)
{
  show_config(widget);
}


void
on_MainWindow_realize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
  initial_setup();
  
  if (pref.explicit_file)
    start_show();
}


void
on_MainWindow_size_allocate            (GtkWidget       *widget,
                                        GdkRectangle    *allocation,
                                        gpointer         user_data)
{
//  fit_page(allocation->width, allocation->height);
}


gboolean
on_nav_window_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_advance_1_page1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  next_page(1);
}


void
on_advance_2_pages1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  next_page(2);
}


void
on_go_to_end1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  goto_end();
}


void
on_backup_1_page1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  previous_page(1);
}


void
on_backup_2_pages1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  previous_page(2);
}


void
on_go_to_start1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  goto_begin();
}


void
on_zoom_to_fit1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_zoom_fit();
}


void
on_enlarge1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_zoom_factor(zoom_factor * 1.1);
}


void
on_reduce1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_zoom_factor(zoom_factor / 1.1);
}


void
on_original_size1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_zoom_factor(1.0);
}


void
on_fit_to_page_width1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_zoom_width(); 
}


void
on_configuration_window1_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  on_pref_btn_clicked(NULL, NULL);
}


void
on_file_list_tbtn_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  file_list_tbtn_clicked();
}


void
on_conf_accel_tview_realize            (GtkWidget       *widget,
                                        gpointer         user_data)
{
  conf_accel_tview_realize(GTK_TREE_VIEW(widget));
}


void
on_conf_accel_tview_cursor_changed     (GtkTreeView     *treeview,
                                        gpointer         user_data)
{
  conf_accel_tview_cursor_changed();
}


void
on_nav_window_realize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
}

void
on_about_box_activate                  (GtkMenuItem     *menu_item,
					gpointer         user_data)
{
  about_box(MainWindow);
}

void
on_goto_page_activate                  (GtkMenuItem     *menu_item,
					gpointer         user_data)
{
  goto_page(MainWindow);
}

void
on_fullscreen_activate                 (GtkMenuItem     *menu_item,
					gpointer         user_data)
{
  toggle_fullscreen();
}

void
on_toggle_btn_clicked                  (GtkButton       *button,
					gpointer         user_data)
{
  toggle_keymode();
}
