/*
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *  
 *  This file is part of carmand-panel.
 *
 *  carmand-panel is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  carmand-panel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#include <hildon/hildon-caption.h>
#include <hildon/hildon-file-selection.h>
#include <hildon/hildon-file-chooser-dialog.h>
#include <hildon/hildon-number-editor.h>

G_BEGIN_DECLS

#define CARMAND_TYPE_SETTINGS		(carmand_settings_get_type ())
#define CARMAND_SETTINGS(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), \
					CARMAND_TYPE_SETTINGS, CarmandSettings))
#define CARMAND_SETTINGS_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST((k), \
					CARMAND_TYPE_SETTINGS, CarmandSettingsClass))
#define CARMAND_IS_SETTINGS(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
					CARMAND_TYPE_SETTINGS))
#define CARMAND_IS_SETTINGS_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE((k), \
					CARMAND_TYPE_SETTINGS))
#define CARMAND_SETTINGS_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), \
					CARMAND_TYPE_SETTINGS, CarmandSettingsClass))


typedef struct _CarmandSettings		CarmandSettings;
typedef struct _CarmandSettingsClass	CarmandSettingsClass;

struct _CarmandSettings
{
	GtkDialog	parent_instance;
	gchar		*user_repo_dir;

	/* instance members */
	CarmandDbus *dbus;
	GSList *list_obd_gps_devs;
	GSList *list_map_repo;
	GSList *list_storage_devs;

	/* Widgets */
	GtkWidget *dialog_path;
	GtkWidget *notebook_tabs;

	/* Connections settings */
	GtkWidget *combo_obd_device;
	GtkWidget *button_obd_conn;
	GtkWidget *combo_gps_device;
	GtkWidget *label_gps_status;
	GtkWidget *button_gps_conn;
	GtkWidget *button_pair_dev;
	GtkWidget *check_mode;

	/* Trip Settings */
	GtkWidget *combo_time_precision;
	GtkWidget *combo_trips_folder;

	/* Maps Settings */
	GtkWidget *combo_maps_folder;
	GtkWidget *combo_repo;
	GtkWidget *add_repo_button;
	GtkWidget *del_repo_button;

	/* Tracks Settings */
	GtkWidget *combo_tracks_folder;

	/* Browsing files */
	HildonFileSelection *tree_filesel_path;
	HildonFileSystemModel *model_path;
};

struct _CarmandSettingsClass
{
	GtkDialogClass parent_class;
	/* class members */
};


/* Carmand Functions */


/* FIXME: Review code below */

#define APP_NAME	"carmand-settings"
#define _(String) dgettext (APP_NAME, String)

#define LOCALEDIR	"/usr/share/locale"

#define FOLDER_SELECTION_HEIGHT 250
#define FOLDER_SELECTION_WIDTH  320

#define CS_TIME_PRECISION_MIN 3
#define CS_TIME_PRECISION_MAX 60
#define CS_FILE_SIZE_MIN -1
#define CS_FILE_SIZE_MAX 2048

enum {
	TOGGLE_COLUMN,
	TEXT_COLUMN,
	PID
};

enum {
	DEVICE_ADDRESS,
	DEVICE_NAME
};

enum {
	MAP_FILE,
	REPO_NAME
};

enum {
	VALUE
};

enum {
	STORAGE_DEVICE,
	STORAGE_NAME
};

/* GLib API Function */
GType carmand_settings_get_type(void) G_GNUC_CONST;

CarmandSettings *carmand_settings_new(GtkWindow *parent);

G_END_DECLS
