#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from common.carlog import DEBUG
from main.editdlgview import EditDlgView
from models.tripsmodel import TripsModel
from main.messagedlgctrl import MessageDlgController

class ResetTripController(object):

    def __init__(self, parent):
        self._parent = parent
        self.trips_model = TripsModel()

    def __del__(self):
       DEBUG("deleting ResetTripController %s" % self)

    def show(self):
        dlg = EditDlgView("RESET TRIP", " You may add " \
            "a label for this trip", "",
            self.__reset_cb)
        dlg.show()

    def __reset_cb(self, dlg, text):
        def hide():
            dlg.hide(True)

        self._parent.hide(True)
        self._parent._parent.hide(True)

        self.trips_model.change_trip_name(self.trips_model.ActualTripFolder(),
            text)
        self.trips_model.ResetTrip()

        msg = MessageDlgController(confirm_cb=hide)
        msg.show_message("Trip saved",
            title="RESET TRIP")
