#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from common.carlog import DEBUG
from main.editdlgview import EditDlgView
from models.tripsmodel import TripsModel
from trips.triplistview import TripListView

class LoadTripController(object):

    def __init__(self, parent):
        self._parent = parent

    def __del__(self):
        DEBUG("deleting LoadTripController %s" % self)

    def show(self):
        self.trip_current = TripsModel().ActualTripFolder()
        view = TripListView("LOAD TRIP", self.__load_trip_cb, True)
        if view.is_empty():
            view.hide(True)
            msg = MessageDlgController()
            msg.show_message("No trips saved", title="LOAD TRIP")
        else:
            view.show()

    def __load_trip_cb(self, obj, item, param):
        obj.hide()
        self._parent.hide(True)
        if self.trip_current == param:
            self._parent._parent.load_current_trip()
        else:
            self._parent._parent.load_trip(param)
            self._parent._parent.set_loaded_trip(param)
