#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#


import evas, ecore, edje

class GraphView(evas.SmartObject):

    def __init__(self, canvas, controller, graph):
        evas.SmartObject.__init__(self, canvas)
        self.controller = controller
        self.clipper = self.Rectangle()
        self.graph = graph
        self.graph.clip_set(self.clipper)
        self.member_add(self.graph)
        self.graph.move(self.pos[0], self.pos[1])
        self.graph.show()
        self.frac_time = 0

    def clip_set(self, obj):
        self.clipper.clip_set(obj)

    def clip_unset(self):
        self.clipper.clip_unset()

    def move_graph(self, time, zoom=None):
        if zoom:
            self.frac_time = float(self.w) / zoom

        x = int(time * self.frac_time) * -1
        x += self.pos[0]
        self.graph.move(x, self.graph.pos[1])

    def show(self):
        self.clipper.show()

    def hide(self):
        self.clipper.hide()

    def resize(self, w, h):
        self.w = w
        self.h = h
        self.clipper.resize(w, h)

    def get_width(self):
        return self.w

    def get_height(self):
        return self.h
