#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os, edje
from main.listctrl import ListView
from common.carmanconfig import CarmanConfig

class ThemeListView(ListView):

    def __init__(self, parent):
        self._parent = parent
        self.config = CarmanConfig()
        self.current = self.config.get_current_theme_path()
        ListView.__init__(self, "list-theme", "list-item-theme",
            "CHOOSE THEME")

        for root, dirs, files in os.walk(self.config.get_theme_root_path()):
            if "theme.edj" in files:
                theme = os.path.join(root, "theme.edj")
                title = edje.file_data_get(theme, "theme.title")
                self.add_item(title, self.__change_theme, root,
                    thumbnail=(theme, "images/thumbnail"))

    def __change_theme(self, obj, item, param):
        self.hide()
        self._parent.hide(True)
        if param != self.current:
            self.config.set_theme_path(param)
            self._parent._parent._parent.set_theme()
