#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#


from common.carlog import DEBUG
from options.speedalertdlgview import SpeedAlertDlgView
from common.carmanconfig import CarmanConfig, METRIC
from models.kbmodel import KeyBoardModel
from models.obdmodel import OBDModel

class SpeedAlertDlgController(object):

    def __init__(self, parent):
        self.parent = parent
        self.metric = CarmanConfig().get_unit() == METRIC
        self.sound =  CarmanConfig().get_speed_alert()
        self.speed_value = CarmanConfig().get_max_speed()
        if not self.metric:
            self.speed_value = (self.speed_value * 62) / 100
            self.speed_value = self._div(self.speed_value)

        self.view = SpeedAlertDlgView(self.speed_value, self.metric)
        self.view.connect_cbs(self.more_cb,
                self.less_cb,
                self.sound_on_cb,
                self.sound_off_cb,
                self.confirm_cb,
                self.cancel_cb)
        self.view.signal_callback_add("hide", "", self.__destroy)

        if self.sound == "ON":
            self.view.signal_emit("enable-on", "")
        else:
            self.view.signal_emit("enable-off", "")

        self.kb_model = KeyBoardModel()
        self.kb_model.add_key_down_cb(self.__key_down_cb)
        self.obd_model = OBDModel()

    def show(self):
        self.view.show()

    def __del__(self):
        DEBUG("deleting Speed Alert %s" % self)

    def __key_down_cb(self, obj, event):
        if event.key == "Escape":
            self.view.signal_emit("hide-anime", "")
            return True
        return False

    def confirm_cb(self, *data):
        if not self.metric:
            self.speed_value = (self.speed_value * 100) / 62
            self.speed_value = self._div(self.speed_value)
        CarmanConfig().set_max_speed(self.speed_value)
        CarmanConfig().set_speed_alert(self.sound)
        if self.sound == "ON":
            self.obd_model.enable_speed_alert(self.speed_value)
        else:
            self.obd_model.disable_speed_alert()
        self.view.hide()
        self.parent.hide(True)

    def cancel_cb(self, *data):
        self.view.hide()

    def more_cb(self, *data):
        self.speed_value += 5
        self.view.value_set(self.speed_value)

    def less_cb(self, *data):
        if self.speed_value >=5:
            self.speed_value -= 5
            self.view.value_set(self.speed_value)

    def sound_on_cb(self, *data):
        self.view.signal_emit("enable-on", "")
        self.view.signal_emit("disable-off", "")
        self.sound = "ON"

    def sound_off_cb(self, *data):
        self.view.signal_emit("enable-off", "")
        self.view.signal_emit("disable-on", "")
        self.sound = "OFF"

    def _div(self, num):
        q,r = divmod(num,10)
        if r<=2:
            return q*10
        elif r>=3 and r<=7:
            return (q*10)+5
        else:
            return (q+1)*10

    def __destroy(self, *data):
        self.kb_model.del_key_down_cb(self.__key_down_cb)
