#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from models.dbusmodel import EDbusModel
from common.singleton import Singleton
from common.carlog import ERROR, INFO, WARNING, DEBUG
from common import dbus_bt

class BtModel(Singleton):

    def __init__(self):
        Singleton.__init__(self)
        self._discovery_start_cb = None
        self._name_update_cb = None
        self._device_found_cb = None
        self._discovery_completed_cb = None
        self._error_cb = None
        self._registered = {}

        self._dbusbt = dbus_bt.DBusBT(EDbusModel().get_main_loop(),
                self._bt_error_cb)
        try:
            self._dbusbt.set_disc_cb(self._bt_discovery_started_cb,\
                    self._bt_name_updated_cb,\
                    self._bt_device_found_cb,\
                    self._bt_discovery_completed_cb)
        except Exception, e:
            ERROR("Error initializing bluetooth model '%s'" % e)

    def connect_callbacks(self, discovery_start_cb=None, name_update_cb=None,\
            device_found_cb=None, discovery_completed_cb=None, error_cb=None):

        self._discovery_start_cb = callable(discovery_start_cb)\
                and discovery_start_cb or None
        self._name_update_cb = callable(name_update_cb)\
                and name_update_cb or None
        self._device_found_cb = callable(device_found_cb)\
                and device_found_cb or None
        self._discovery_completed_cb = callable(discovery_completed_cb)\
                and discovery_completed_cb or None
        self._error_cb = callable(error_cb) and error_cb or None

    def start_discovery(self):
        try:
            self._dbusbt.start_discovery()
        except Exception, err:
            self._dbusbt._disc_completed_signal()
            self._dbusbt.cancel_discovery()
            DEBUG('Got a D-Bus error: %s' % err)

    def cancel_discovery(self):
        self._dbusbt.cancel_discovery()

    def has_bonding(self, address):
        if address == "internal":
            return True
        return self._dbusbt.has_bonding(address)

    def passkey_register(self, address, bonding_cb):
        if not callable(bonding_cb):
            return

        if self._registered.has_key(address):
            self._registered[address] = None

        passkey = dbus_bt.CarmanPasskeyAgent(EDbusModel().get_main_loop(),\
                    address, bonding_cb)
        passkey.register()
        self._registered[address] = passkey


    def passkey_success(self, address, passwd):
        if self._registered.has_key(address):
            self._registered[address].success(passwd)

    #CallBacks
    def _bt_error_cb(self, error=None):
        if self._error_cb is not None:
            self._error_cb()

    def _bt_discovery_started_cb(self):
        if self._discovery_start_cb is not None:
            self._discovery_start_cb()

    def _bt_discovery_completed_cb(self):
        if self._discovery_completed_cb is not None:
            self._discovery_completed_cb()

    def _bt_device_found_cb(self, address):
        if self._device_found_cb is not None:
            self._device_found_cb(address)

    def _bt_name_updated_cb(self, address, name):
        if self._name_update_cb is not None:
            self._name_update_cb(address, name)

