#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from maps.progressbarview import ProgressBarView

class ProgressBarController(object):

    def __init__(self, canvas):
        self.last_value = 0
        self.visible = False
        self.view = ProgressBarView(canvas)

    def set_view(self, theme, view):
        self.screen = view
        self.view.set_theme(theme)
        view.part_swallow("progress-bar", self.view)
        if self.visible:
            self.show()

    def show(self):
        if not self.visible:
            self.update(0)
        else:
            self.view.update(self.last_value)
        self.visible = True
        self.screen.signal_emit("show-progressbar", "")

    def hide(self):
        self.visible = False
        self.screen.signal_emit("hide-progressbar", "")

    def update(self, pos):
        self.last_value = pos
        self.view.update(pos)
