#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from main.configurebt import ConfigureGPS
from maps.buddylistctrl import BuddyListController
from maps.tracklistview import TrackListView
from maps.managemaps import ManageMaps
from models.gpsmodel import GPSModel
from models.infosharingmodel import ISManagerModel
from maps.selectmapservice import SelectMapService
from maps.loadtrackctrl import LoadTrackController
from options.globaloptview import GlobalOptionsView
from main.messagedlgctrl import MessageDlgController

class OptionController(object):

    def __init__(self, parent):
        """
        Controller Constructor
        @param parent: Parent Controller
        """
        self._parent = parent
        self.ism_model = ISManagerModel()

    def show(self):
        view = GlobalOptionsView(self._parent)

        if self.ism_model.has_buddies():
            view.add_item("Disconnect friend", self.__disconnect)
        view.add_item("Follow friend", self.__follow_friend)
        view.add_item("Configure GPS", self.__configure_gps)
#        view.add_item("Load track", self.__load_track)
        view.add_item("Manage maps", self.__manage_maps)
        view.add_item("Select map service", self.__select_map_repository)
        view.add_global_items()
        view.show()

    def __disconnect(self, obj, item, param):
        def disconnect():
            obj.hide(True)
            for info in self.ism_model.get_buddies_info():
                self._parent.disconnect_buddy(info[0], True)

        msg = MessageDlgController(confirm_cb=disconnect)
        msg.show_message("Do you want disconnect?", buttons=2,
            title="DISCONNECT FRIEND")

    def __select_map_repository(self, obj, item, param):
        view = SelectMapService(obj)
        view.show()

    def __configure_gps(self, obj, item, param):
        def item_selected(obj2, item, param):
            def reconnect():
                obj.hide(True)
                obj2.hide(True)
                model.disconnect()
                model.connect(param)

            status = model.Status()
            if status == GPSModel.FIXING or status == GPSModel.FIXED:
                msg = MessageDlgController(confirm_cb=reconnect)
                msg.show_message("GPS is already connected<br>Do you " \
                    "want disconnect?", title="CONFIGURE GPS", buttons=2)
            else:
                obj2.hide()
                obj.hide(True)
                model.connect(param)

        model = GPSModel()
        view = ConfigureGPS(item_selected)
        view.show()

    def __follow_friend(self, obj, item, param):
        buddy = BuddyListController(obj)
        if buddy.load_list():
            buddy.show()

    """
    def __load_track(self, obj, item, param):
        def track_selected(obj2, item, param):
            if param != current:
                loadtrack = LoadTrackController(obj2)
                loadtrack.load(param)
            else:
                obj2.hide()
                obj.hide(True)
                self._parent.unload_track_aux()

        current = self._parent.get_selected_track()
        tracklist = TrackListView(obj, True, track_selected)
        tracklist.show(current)
    """

    def __manage_maps(self, obj, item, param):
        mng = ManageMaps(obj)
        mng.show()
