#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from main.basedlgview import BaseDlgView
from models.kbmodel import KeyBoardModel
from main.messagedlgctrl import MessageDlgController

class MapZoomDlgView(BaseDlgView):

    def __init__(self, size_list, cb):
        self.urban = False
        self.city = False
        self.state = False
        self.callback = cb

        BaseDlgView.__init__(self, "mapzoom", 30)
        self.signal_callback_add("urban_zoom_clicked", "",
                                 self.__urban_zoom_selected_cb)
        self.signal_callback_add("city_zoom_clicked", "",
                                 self.__city_zoom_selected_cb)
        self.signal_callback_add("state_zoom_clicked", "",
                                 self.__state_zoom_selected_cb)
        self.signal_callback_add("confirm_bt_clicked", "", self.__confirm_cb)
        self.signal_callback_add("cancel_bt_clicked", "", self.__cancel_cb)
        self.signal_callback_add("hide-anime", "", self.__destroy)

        self.kb_model = KeyBoardModel()
        self.kb_model.add_key_down_cb(self.__key_down_cb)

        self.part_text_set("urban_zoom_size", self.__get_size(size_list[0]))
        self.part_text_set("city_zoom_size", self.__get_size(size_list[1]))
        self.part_text_set("state_zoom_size", self.__get_size(size_list[2]))

    def __get_size(self, size):
        if size < 1024:
            return "%dKb" % size
        else:
            return "%dMb" % (size / 1024)

    def __key_down_cb(self, obj, event):
        if event.key == "Escape":
            self.__cancel_cb()
        elif event.key == "Return" or event.key == "KP_Enter":
            self.__confirm_cb()
        else:
            return False
        return True

    def __urban_zoom_selected_cb(self, *cb):
        if self.urban:
            self.signal_emit("disable-urban", "")
        else:
            self.signal_emit("enable-urban", "")
        self.urban = not self.urban

    def __city_zoom_selected_cb(self, *cb):
        if self.city:
            self.signal_emit("disable-city", "")
        else:
            self.signal_emit("enable-city", "")
        self.city = not self.city

    def __state_zoom_selected_cb(self, *cb):
        if self.state:
            self.signal_emit("disable-state", "")
        else:
            self.signal_emit("enable-state", "")
        self.state = not self.state

    def __cancel_cb(self, *param):
        self.hide()

    def __confirm_cb(self, *param):
        if not self.urban and not self.city and not self.state:
            msg = MessageDlgController()
            msg.show_message("You need select a zoom first.")
        else:
            indexes = []
            if self.urban:
                indexes.append(0)
            if self.city:
                indexes.append(1)
            if self.state:
                indexes.append(2)
            self.callback(self, indexes)

    def __destroy(self, *data):
        self.kb_model.del_key_down_cb(self.__key_down_cb)
