#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from common.carlog import ERROR
from models.btmodel import BtModel
from main.listctrl import ListView
from models.dbusmodel import CarmandDbusModel

class ConfigureBT(ListView):

    def __init__(self, tittle, device, cb):
        self.device = device
        self.searching_devices = False
        self.__cb = callable(cb) and cb or None
        ListView.__init__(self, "list-normal", "list-item-checkbox", tittle)

        self.bt_model = BtModel()
        self.bt_model.connect_callbacks(self.__discovery_started,
                self.__name_updated, None, self.__discovery_completed)
        self.signal_callback_add("button-back-pressed", "",
            self.__cancel_discovery)

    def destroy(self, *params):
        self.__cb = None
        ListView.destroy(self, *params)

    def show(self):
        ListView.show(self)
        try:
            self.bt_model.start_discovery()
        except Exception, e:
            ERROR("could not start bluetooth discovery: %s" % e)

    def __cancel_discovery(self, *params):
        if self.searching_devices:
            try:
                self.bt_model.cancel_discovery()
            except Exception, e:
                ERROR("could not stop bluetooth discovery: %s" % e)
        self.searching_devices = False
        self.bt_model.connect_callbacks()

    def __wrapper_cb(self, obj, item, param):
        self.__cancel_discovery()
        if self.__cb:
            self.__cb(obj, item, param)

    def __discovery_started(self):
        self.searching_devices = True

    def __discovery_completed(self):
        self.searching_devices = False

    def __name_updated(self, address, name):
        self.add_item(name, self.__wrapper_cb, address,
            check=(address == self.device))


class ConfigureOBD(ConfigureBT):

    def __init__(self, cb):
        self.cb = callable(cb) and cb or None
        self.carmand_model = CarmandDbusModel()
        ConfigureBT.__init__(self, "CONFIGURE OBD2",
            self.carmand_model.GetOBDDevice(), self.__set_device)

    def __set_device(self, obj, item, param):
        self.carmand_model.SetOBDDevice(param)
        self.carmand_model.SaveConfiguration()
        if self.cb:
            self.cb(obj, item, param)


class ConfigureGPS(ConfigureBT):

    def __init__(self, cb):
        self.cb = callable(cb) and cb or None
        self.carmand_model = CarmandDbusModel()
        ConfigureBT.__init__(self, "CONFIGURE GPS",
            self.carmand_model.GetGPSDevice(), self.__set_device)

    def __set_device(self, obj, item, param):
        self.carmand_model.SetGPSDevice(param)
        self.carmand_model.SaveConfiguration()
        if self.cb:
            self.cb(obj, item, param)
