#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os, edje
from common.carlog import DEBUG
from main.mainview import MainView
from common.carmanconfig import CarmanConfig

class BaseDlgView(edje.Edje):

    def __init__(self, group, layer=15):
        canvas = MainView().get_evas_canvas()
        theme = CarmanConfig().get_current_theme()
        edje.Edje.__init__(self, canvas, file=theme, group=group)
        self.layer_set(layer)
        self.signal_callback_add("hide", "", self.__destroy)

    def __del__(self):
        DEBUG("deleting %s" % self)

    def hide(self, hide_now=False):
        if hide_now:
            self.signal_emit("hide", "")
        else:
            self.signal_emit("hide-anime", "")

    # CallBacks
    def __destroy(self, *params):
        self.delete()

