#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os, gdbm
from main.listctrl import ListView
from models.obdmodel import OBDModel
from common.carlog import DEBUG
from common.carmanconfig import CarmanConfig

class TroubleListView(ListView):

    def __init__(self):
        self.current = CarmanConfig().get_repository_default_name()
        ListView.__init__(self, "list-normal", "list-item-trouble",
            "TROUBLE LIST")

        self.model = OBDModel()
        self.model.add_dtc_list_cb(self.__on_dtc_list_cb)
        self.model.RequestDTCList()

        try:
            self.dtc_db = gdbm.open("/usr/share/carman/dtcs.db", "r")
        except:
            self.dtc_db = None
            DEBUG("unable to open DTC database!")

        self.signal_callback_add("button-back-pressed", "",
            self.__remove_callback)

    def __del__(self):
        DEBUG("deleting TroubleListView %s" % self)
        if self.dtc_db:
            self.dtc_db.close()

    def __on_dtc_list_cb(self, dtcs):
        if dtcs:
            for dtc in dtcs:
                if self.dtc_db and self.dtc_db.has_key(dtc):
                    self.add_item("%s - %s" % (dtc, self.dtc_db[dtc]), None)
                else:
                    self.add_item("%s <color>(NOT AVAILABLE)" % dtc, None)
        else:
            self.add_item("No Troubles found", None)

    def __remove_callback(self, *data):
        self.model.del_dtc_list_cb(self.__on_dtc_list_cb)
