#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from models.obdmodel import OBDModel
from main.configurebt import ConfigureOBD
from options.globaloptview import GlobalOptionsView
from main.messagedlgctrl import MessageDlgController
from gauges.accelerationrankctrl import AccelerationRankController

class OptionController(object):

    def __init__(self, parent):
        """
        Controller Constructor
        @param parent: Parent Controller
        """
        self._parent = parent

    def show(self):
        view = GlobalOptionsView(self._parent)
        view.add_item("Acceleration ranking", self.__acceleration_ranking)
        view.add_item("Configure OBD2", self.__configure_obd)
        view.add_global_items()
        view.show()

    def __configure_obd(self, obj, item, param):
        def item_selected(obj2, item, param):
            def reconnect():
                obj.hide(True)
                obj2.hide(True)
                model.disconnect()
                model.connect(param)

            if model.Status() == OBDModel.CONNECTED:
                msg = MessageDlgController(confirm_cb=reconnect)
                msg.show_message("OBD2 is already connected<br>Do you " \
                    "want disconnect?", title="CONFIGURE OBD2", buttons=2)
            else:
                obj2.hide()
                obj.hide(True)
                model.connect(param)

        model = OBDModel()
        view = ConfigureOBD(item_selected)
        view.show()

    def __acceleration_ranking(self, obj, item, param):
        ctrl = AccelerationRankController()
        if ctrl.has_records():
            ctrl.show()
        else:
           dlg = MessageDlgController()
           dlg.show_message("No acceleration rankings.")
