#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os
from common.carlog import DEBUG
from common.carmanconfig import CarmanConfig
from accelerationrankview import AccelerationRankView

class AccelerationRankController(object):

    def __init__(self):
        self.lines = []
        rank_file = os.path.join(CarmanConfig().get_carman_home_dir(),
                    "acceleration_ranking")
        if os.path.exists(rank_file):
            fd = open(rank_file, "r")
            lines = fd.readlines()
            lines = [line.split() for line in lines]
            try:
                self.lines = [[int(a), float(b)] for a, b in lines]
            except:
                self.lines = []
            fd.close()

    def __del__(self):
        DEBUG("deleting AccelerationRank Controller %s" % self)

    def has_records(self):
        return len(self.lines) > 0

    def show(self):
        view = AccelerationRankView()
        view.set_bar(self.lines)
        view.show()
