#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from main.listctrl import ListView
from options.themelistview import ThemeListView
from options.speedalertdlgctrl import SpeedAlertDlgController
from options.unitlistview import UnitListView

class GlobalOptionsView(ListView):

    def __init__(self, parent):
        self._parent = parent
        ListView.__init__(self, "list-normal", "list-item-normal",
            "OPTIONS")

    def add_global_items(self):
        self.add_item("Speed alert", self.__speed_alert)
        self.add_item("Choose theme", self.__choose_theme)
        self.add_item("Change unit", self.__change_unit)

    def __change_unit(self, obj, item, param):
        unit = UnitListView(self)
        unit.show()

    def __choose_theme(self, obj, item, param):
        theme = ThemeListView(self)
        theme.show()

    def  __speed_alert(self, obj, item, param):
        speed = SpeedAlertDlgController(self)
        speed.show()
