#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from rtree import Rtree
from models.mapmodel import MapModel

class TrackModel(object):

    def __init__(self):
        self.clear()
        self.selected_track = None

    def clear(self):
        self.models = []
        self.current_model = None
        self.empty = True

    def clear_selected_track(self):
        self.selected_track = None

    def new_track(self):
        if not self.empty or self.current_model is None:
            self.current_model = Rtree()
            self.empty = True
            self.models.append(self.current_model)

    def add_point(self, point):
        self.current_model.add(point)
        self.empty = False

    def get_track_area(self, area):
        track = []
        for model in self.models:
            intersec = model.intersection(area, sort=True, region=True)
            if intersec:
                prev_id, point  = intersec[0]
                point = int(point[0]), int(point[1])
                seg = [point]
                for id, point in intersec:
                    point = int(point[0]), int(point[1])
                    if id - prev_id == 1:
                        seg.append(point)
                    else:
                        if len(seg) > 1:
                            track.append(seg)
                        seg = [point]
                    prev_id = id

                if len(seg) > 1:
                    track.append(seg)
        return track

    def set_models(self, models, trackfile):
        self.empty = True
        self.models = models
        self.current_model = None
        self.selected_track = trackfile

    def get_selected_track(self):
        return self.selected_track

    def finalize(self):
        pass
