#  osmrepo.py - Open Street Maps repository
#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from models.reposet import RepoBase

class OSMRepo(RepoBase):
    NAME = "Open Street"
    CACHE_NAME = ".osmcache"
    URI = "http://tile.openstreetmap.org/%d/%d/%d.png"

    def build_uri(self, tile_x, tile_y, zoom):
        return self.URI % (self.ZOOM[-1] - zoom, tile_x, tile_y)

def get_repository():
    return OSMRepo()
