#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
from common.carlog import INFO

if sys.hexversion >= 0x20500f0:
    try:
        import xml.etree.cElementTree
        __ElementTree__ = xml.etree.cElementTree
    except ImportError:
        import xml.etree.ElementTree
        __ElementTree__ = xml.etree.ElementTree
        INFO('Unable to use cElementTree. Using ElementTree instead.')
else:
    try:
        import cElementTree
        __ElementTree__ = cElementTree
    except ImportError:
        import elementtree.ElementTree
        __ElementTree__ = elementtree.ElementTree
        INFO('Unable to use cElementTree. Using ElementTree instead.')

def get_xml_parser():
    """
    Returns the Element Tree module
    """
    return __ElementTree__
# get_elementtree
