#!/usr/bin/env python
# -*- coding: UTF8 -*-
#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import dbus
from common.singleton import Singleton
from common.carlog import WARNING

__DBUS_BLUEZ_SERVICE__ = 'org.bluez'
__DBUS_BLUEZ_PATH__ = '/org/bluez'
__DBUS_BLUEZ_ADAPTER__ = '/org/bluez/hci0'
__DBUS_BLUEZ_ADAPTER_SERVICE__ = __DBUS_BLUEZ_SERVICE__ + '.Adapter'
__DBUS_SERVICE__ = 'org.freedesktop.DBus'
__DBUS_PATH__ = '/org/freedesktop/DBus'

class BluetoothAdapter(Singleton):

    def __init__(self):
        Singleton.__init__(self)
        self._bus = dbus.SystemBus()
        bluez_object = self._bus.get_object(__DBUS_BLUEZ_SERVICE__,
                                           __DBUS_BLUEZ_ADAPTER__,
                                           introspect=False)
        self._bluez_adapter = dbus.Interface(bluez_object,
                                            __DBUS_BLUEZ_ADAPTER_SERVICE__)
        self._mode = ''
    # __init__

    def turn_on(self):
        try:
            mode = self._bluez_adapter.GetMode()
        except dbus.DBusException, err:
            WARNING('Unable to get the current bluetooth device mode: %s' \
                    % err)
            return
        if not self._mode:
            self._mode = mode

        if mode == 'off':
            try:
                mode = self._bluez_adapter.SetMode('connectable')
            except dbus.DBusException, err:
                WARNING('Unable to turn on bluetooth device: %s' % err)
    # turn_on

    def turn_off(self):
        if self._mode == 'off':
            try:
                mode = self._bluez_adapter.SetMode('off')
            except dbus.DBusException, err:
                WARNING('Unable to turn on bluetooth device: %s' % err)
        self._mode = ''
    # turn_off
# BluetoothAdapter
