#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from main.basedlgview import BaseDlgView

class SpeedAlertDlgView(BaseDlgView):

    def __init__(self, value, metric=True):
        BaseDlgView.__init__(self, "speedalert", 25)
        if metric:
            self.unit = " Km/h"
        else:
            self.unit = " mph"
        self.value_set(value)

    def value_set(self, value):
        self.part_text_set("max_display", str(value)+self.unit)

    def connect_cbs(self, more_cb, less_cb, sound_on_cb, sound_off_cb,
            confirm_cb, cancel_cb):
        self.more_speed_connect_cb(more_cb)
        self.less_speed_connect_cb(less_cb)
        self.sound_on_cb(sound_on_cb)
        self.sound_off_cb(sound_off_cb)
        self.confirm_connect_cb(confirm_cb)
        self.cancel_connect_cb(cancel_cb)

    def more_speed_connect_cb(self, cb):
        self.signal_callback_add("more_speed_bt_clicked", "", cb)

    def less_speed_connect_cb(self, cb):
        self.signal_callback_add("less_speed_bt_clicked", "", cb)

    def sound_on_cb(self, cb):
        self.signal_callback_add("sound_on_bt_clicked", "", cb)

    def sound_off_cb(self, cb):
        self.signal_callback_add("sound_off_bt_clicked", "", cb)

    def confirm_connect_cb(self, cb):
        self.signal_callback_add("confirm_bt_clicked", "", cb)

    def cancel_connect_cb(self, cb):
        self.signal_callback_add("cancel_bt_clicked", "", cb)
