#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import e_dbus, dbus
from common.carlog import DEBUG
from common.singleton import Singleton

DBUS_ADDRESS       = "unix:path=/var/run/carmand-dbus-path"
DBUS_BUS_NAME      = "org.indt.carmand"
DBUS_OBJECT_PATH   = "/org/indt/carmand"
DBUS_IFACE_CONFIG  = "org.indt.carmand.Configuration"
DBUS_IFACE_GPS     = "org.indt.carmand.GPS"
DBUS_IFACE_OBD     = "org.indt.carmand.OBD"
DBUS_IFACE_TRIP    = "org.indt.carmand.Trip"

class EDbusModel(Singleton):

    def __init__(self):
        """ EDbus Model constructor """
        Singleton.__init__(self)
        self.__main_loop = e_dbus.DBusEcoreMainLoop()

    def get_main_loop(self):
        """ Return ecore dbus main_loop """
        return self.__main_loop


class CarmandDbusModel(Singleton, dbus.Interface):

    def __init__(self):
        Singleton.__init__(self)

        dbus.set_default_main_loop(EDbusModel().get_main_loop())
        self._bus = dbus.bus.BusConnection(DBUS_ADDRESS)
        self._bus_object = self._bus.get_object(DBUS_BUS_NAME,
                                                DBUS_OBJECT_PATH)
        dbus.Interface.__init__(self, self._bus_object, DBUS_IFACE_CONFIG)

        self.__name_owner_changed_cbs = []
        self._bus.add_signal_receiver(self.__name_owner_changed_cb,
            dbus_interface="org.freedesktop.DBus",
            signal_name="NameOwnerChanged")

    def __name_owner_changed_cb(self, *data):
        DEBUG("name owner changed %s" % list(data))
        for cb in self.__name_owner_changed_cbs:
            cb(*data)

    def add_name_owner_changed_cb(self, cb):
        if callable(cb) and cb not in self.__name_owner_changed_cbs:
            self.__name_owner_changed_cbs.append(cb)

    def del_name_owner_changed_cb(self, cb):
        if cb in self.__name_owner_changed_cbs:
            self.__name_owner_changed_cbs.remove(cb)

    def get_bus_object(self):
        return self._bus_object

    def get_bus(self):
        return self._bus
