#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os, glob
from common.carlog import DEBUG
from main.listctrl import ListView
from models.dbusmodel import CarmandDbusModel
from main.messagedlgctrl import MessageDlgController

class TrackListView(ListView):

    def __init__(self, parent, checkbox, cb):
        self.tracks = []
        self._parent = parent
        self.checkbox = checkbox
        self.cb = callable(cb) and cb or None
        tracks_folder = CarmandDbusModel().GetTracksFolder()
        for filepath in glob.glob(os.path.join(tracks_folder, "*.gpx")):
            filename = os.path.basename(filepath).rsplit(".", 1)[0]
            self.tracks.append((filename, filepath))
        if self.checkbox:
            ListView.__init__(self, "list-normal", "list-item-checkbox",
                "LOAD TRACKS")
        else:
            ListView.__init__(self, "list-normal", "list-item-normal",
                "LOAD TRACKS")

    def show(self, current=""):
        if not self.tracks:
            self.hide(True)
            msg = MessageDlgController()
            msg.show_message("No tracks saved", title="LOAD TRACKS")
            return

        if self.checkbox:
            for item in self.tracks:
                self.add_item(item[0], self.cb, item[1],
                    check=current == item[1], toggled=True)
        else:
            for item in self.tracks:
                self.add_item(item[0], self.cb, item[1])
        ListView.show(self)
