#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from common.carlog import DEBUG
from models.gpsmodel import GPSModel
from models.infosharingmodel import ISPurpleModel, ISManagerModel
from main.messagedlgctrl import MessageDlgController
from maps.buddylistview import BuddyListView

class BuddyListController(object):

    def __init__(self, parent):
        self.buddies = []
        self._parent = parent
        self.purple = ISPurpleModel()
        self.manager = ISManagerModel()

    def __del__(self):
        DEBUG("deleting BuddyListController %s" % self)

    def load_list(self):
        status = GPSModel().Status()
        if status != GPSModel.FIXING and status != GPSModel.FIXED:
            msg = MessageDlgController()
            msg.show_message("GPS not ready", title="FOLLOW FRIEND")
            return False

        if not self.purple.connect():
            msg = MessageDlgController()
            msg.show_message("Pidgin not available", title="FOLLOW FRIEND")
            return False

        if not self.manager.connect():
            msg = MessageDlgController()
            msg.show_message("Pidgin plugin not activated",
                title="FOLLOW FRIEND")
            return False

        accounts = self.purple.get_accounts_active()
        if not accounts:
            msg = MessageDlgController()
            msg.show_message("No account on-line", title="FOLLOW FRIEND")
            return False

        self.buddies = self.purple.get_buddies_online(accounts)
        if not self.buddies:
            msg = MessageDlgController()
            msg.show_message("No buddies on-line", title="FOLLOW FRIEND")
            return False

        return True

    def show(self):
        view = BuddyListView(self)
        infos = self.manager.get_buddies_info()
        buddies_connected = dict([[info[2], info[0]] for info in infos])
        view.set_buddies(self.buddies, buddies_connected)
        view.show()
