#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{SelectMapService}.
"""

from main.listctrl import ListView
from models.reposet import RepositoriesSet
from models.mapmodel import MapModel
from common.carmanconfig import CarmanConfig


class SelectMapService(ListView):
    """
    Selects a Map Service.

    @type   parent: L{GlobalOptionsView}
    @param  parent: Parent window.
    """
    def __init__(self, parent):
        self.config = CarmanConfig()
        self._parent = parent
        self.current = self.config.get_repository_default_name()
        ListView.__init__(self, "list-normal", "list-item-checkbox",
            "SELECT MAP SERVICE")

        repositories = RepositoriesSet()
        for desc in repositories.load_plugins_description():
            self.add_item(desc[0], self.__repo_selected, desc[1],
                check = desc[1] == self.current)

    def __repo_selected(self, obj, item, param):
        """
        Called when the user selects a map service.

        @type   obj: L{SelectMapService}
        @param  obj: Not used.
        @type   item: L{ListItemView}
        @param  item: Not used.
        @type   param: string
        @param  param: Map service name.
        """
        self.hide()
        self._parent.hide(True)
        if self.current != param:
            self.config.set_repository_default_name(param)
            MapModel().choose_repository(param)
