/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of infosharingd.
 *
 *  pidgin-carman is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  pidgin-carman is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with pidgin-carman.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __DBUS_H__
#define __DBUS_H__


#include <dbus/dbus.h>
#ifdef DEBUG
#define debug_fprintf(mesg...)     \
	fprintf(stderr, mesg)
#else
#define debug_fprintf(mesg...)
#endif

/* D-Bus definitions */
#define CARMAND_BUS_PATH	"unix:path=/var/run/carmand-dbus-path"

struct infosharingd_event {
	gboolean (*request_add) (char *remote_user, char *alias,
				 char *message);
	gboolean (*request_authorize) (char *remote_user, char *alias,
				       char *message, gboolean on_list);
	gboolean (*buddy_signed_on) (char *username, char *alias);
	gboolean (*buddy_signed_off) (char *username, char *alias);
	gboolean (*signed_on) (char *username, char *protocol_id);
	gboolean (*signed_off) (char *username, char *protocol_id);
	gboolean (*connection_error) (char *username, char *protocol_id,
				      char *sdesc, char *desc);
	gboolean (*receiving_im_message) (char *sender, char *alias,
				  char *stripped);
};

int dbus_init_events(struct infosharingd_event *event);
int dbus_init(DBusConnection *conn);
void dbus_exit(void);

#endif /* __DBUS_H__ */
