#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import logging
log = logging.getLogger("plugins.canola-core.settings.general")

from terra.core.manager import Manager
from terra.core.plugin_prefs import PluginPrefs

mger = Manager()
SettingsModelFolder = mger.get_class("Model/Settings/Folder")
SettingsActionModel = mger.get_class("Model/Settings/Action")


class GeneralSettingsModelFolder(SettingsModelFolder):
    terra_type = "Model/Settings/Folder/Root/General"
    title = "General"
    children_prefixes = ["Model/Settings/Action/General"]


class DisplayLitWhenChargingSettingsModel(SettingsActionModel):
    terra_type = "Model/Settings/Action/General/DisplayLitWhenCharging"
    name = "Display lit when charging"

    def __init__(self, parent=None):
        SettingsActionModel.__init__(self, parent)

        s = PluginPrefs("settings")
        value = s.get("display_lit_when_charging")
        if value is None:
            value = True
        self.checked = value

    def execute(self):
        if not mger.screen_powersave:
            return

        s = PluginPrefs("settings")
        value = not bool(s.get("display_lit_when_charging"))
        s["display_lit_when_charging"] = value
        s.save()
        self.checked = value
        self._adjust_screen_powersave(value)

    # XXX: Cf. _adjust_screen_powersave in main/controller.
    def _adjust_screen_powersave(self, value):
        batt = mger.get_status_notifier("Battery")

        if batt is None:
            return

        if batt.status[0] == batt.BATTERY_CHARGING_ON:
            mger.screen_powersave.enabled = not value

class AlternativeThumbnailScreenSettingsModel(SettingsActionModel):
    terra_type = "Model/Settings/Action/General/AlternativeThumbnailScreen"
    name = "Use alternative thumb screen"

    def __init__(self, parent=None):
        SettingsActionModel.__init__(self, parent)

        s = PluginPrefs("settings")
        value = s.get("alternative_thumb_screen")
        if value is None:
            value = False
        self.checked = value

    def execute(self):
        s = PluginPrefs("settings")
        value = not bool(s.get("alternative_thumb_screen"))
        s["alternative_thumb_screen"] = value
        s.save()
        self.checked = value
